%define _unpackaged_files_terminate_build 1

%define oname contextlib2
%def_with check

Name: python3-module-%oname
Version: 0.6.0
Release: alt1

Summary: Backports and enhancements for the contextlib module

Group: Development/Python3
License: LGPLv2+
Url: https://pypi.org/project/contextlib2/

# Source-git: https://github.com/jazzband/contextlib2.git
Source: %name-%version.tar
Patch0: %name-%version-alt.patch

BuildArch: noarch

BuildRequires(pre): rpm-build-python3

%if_with check
BuildRequires: python3(tox)
BuildRequires: python3(tox_no_deps)
%endif

%description
contextlib2 is a backport of the standard library's contextlib
module to earlier Python versions.

It also serves as a real world proving ground for possible
future enhancements to the standard library version.

%prep
%setup
%autopatch -p1

%build
%python3_build

%install
%python3_install

%check
export PIP_NO_INDEX=YES
export TOXENV=py3
tox.py3 --sitepackages --no-deps -vvr -s false

%files
%python3_sitelibdir/contextlib2.py
%python3_sitelibdir/__pycache__/contextlib2.cpython-*.py*
%python3_sitelibdir/contextlib2-*.egg-info/

%changelog
