%define modname convertdate
# https://bugzilla.altlinux.org/show_bug.cgi?id=39164
%def_enable check

Name: python3-module-%modname
Version: 2.3.2
Release: alt1

Summary: Utils for converting between date formats and calculating holidays
License: MIT
Group: Development/Python3
Url: https://pypi.python.org/pypi/convertdate/
BuildArch: noarch

Vcs: https://github.com/fitnr/convertdate.git
Source: https://github.com/fitnr/%modname/archive/v%version/%modname-%version.tar.gz

BuildRequires(pre): rpm-build-python3
%{?_enable_check:BuildRequires: python3-module-pytest python3-module-pymeeus python3-module-pytz}

%py3_provides %modname
%py3_requires pytz pymeeus

%description
Converts between Gregorian dates and other calendar systems. Calendars
included: Baha'i, French Republican, Hebrew, Indian Civil, Islamic,
Julian, Mayan and Persian.

%prep
%setup -n %modname-%version

%build
%python3_build_debug

%install
%python3_install

%check
export PYTHONPATH=%buildroot/%python3_sitelibdir
py.test-3 tests

%files
%python3_sitelibdir/*
%doc *.rst *.md

%changelog
