%define pypi_name django_compressor

%define oname django-compressor

Name: python3-module-%oname
Version: 2.4.1
Release: alt1

Summary: Compresses linked and inline JavaScript or CSS into single cached files

Group: Development/Python3
License: MIT
Url: https://pypi.org/project/%pypi_name

BuildArch: noarch

Source: %pypi_name-%version.tar.gz

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-django-appconf >= 1.0.3
BuildRequires: python3-module-rcssmin >= 1.0.6
BuildRequires: python3-module-rjsmin >= 1.1.0

Requires: python3-module-django-appconf >= 1.0.3
Requires: python3-module-rcssmin  >= 1.0.6
Requires: python3-module-rjsmin >= 1.1.0

%description
Django Compressor combines and compresses linked and inline Javascript
or CSS in a Django templates into cacheable static files by using the
``compress`` template tag.  HTML in between ``{%% compress js/css %%}``
and ``{%% endcompress %%}`` is parsed and searched for CSS or JS. These
styles and scripts are subsequently processed with optional,
configurable compilers and filters.

%package tests
Summary: Tests of %oname
Group: Development/Python3
Requires: %name = %EVR

%description tests
Django Compressor combines and compresses linked and inline Javascript
or CSS in a Django templates into cacheable static files by using the
``compress`` template tag.  HTML in between ``{%% compress js/css %%}``
and ``{%% endcompress %%}`` is parsed and searched for CSS or JS. These
styles and scripts are subsequently processed with optional,
configurable compilers and filters.

This package contein tests.

%prep
%setup -n %pypi_name-%version

# Remove bundled egg-info
#rm -rf %pypi_name.egg-info

%build
%python3_build

%install
%python3_install

%files
%doc README.rst LICENSE
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*/tests
%exclude %python3_sitelibdir/*/test_settings.py

%files tests
%python3_sitelibdir/*/tests
%python3_sitelibdir/*/test_settings.py

%changelog
