%define _unpackaged_files_terminate_build 1
%define oname dugong

%def_with check

Name: python3-module-%oname
Version: 3.7.5
Release: alt1
Summary: Provides an API for communicating with HTTP 1.1 servers
License: Python-2.0
Group: Development/Python3
BuildArch: noarch
Url: https://pypi.org/project/dugong/

Source: %name-%version.tar
Patch0: %name-%version-alt.patch

BuildRequires(pre): rpm-build-python3

%if_with check
BuildRequires: python3(asyncio)
BuildRequires: python3(tox)
%endif

%py3_provides %oname
%py3_requires asyncio

%description
The Python Dugong module provides an API for communicating with HTTP 1.1
servers. It is an alternative to the standard library's http.client
(formerly httplib) module.

%prep
%setup
%autopatch -p1

%build
%python3_build_debug

%install
%python3_install

%check
cat > tox.ini <<EOF
[testenv]
usedevelop=True
whitelist_externals =
    /bin/cp
    /bin/sed
commands_pre =
    /bin/cp %_bindir/py.test3 {envbindir}/py.test
    /bin/sed -i '1c #!{envpython}' {envbindir}/py.test
commands =
    {envbindir}/py.test {posargs:-vra}
EOF
export PIP_NO_BUILD_ISOLATION=no
export PIP_NO_INDEX=YES
export TOXENV=py3
tox.py3 --sitepackages -vvr

%files
%doc *.rst examples
%python3_sitelibdir/*

%changelog
