%define oname ed25519

Name: python3-module-%oname
Version: 1.5
Release: alt1

Summary: Python bindings to the Ed25519 public-key signature system
License: MIT
Group: Development/Python3
Url: https://pypi.python.org/pypi/ed25519/

# https://github.com/warner/python-ed25519.git
Source: %name-%version.tar
Patch0: fix-detecting-version.patch

BuildRequires(pre): rpm-build-python3
Conflicts: python-module-%oname


%description
This offers a comfortable python interface to a C implementation of the
Ed25519 public-key signature system (http://ed25519.cr.yp.to/), using
the portable 'ref' code from the 'SUPERCOP' benchmarking suite.

This system provides high (128-bit) security, short (32-byte) keys,
short (64-byte) signatures, and fast (2-6ms) operation. Please see the
README for more details.

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR

%description tests
This offers a comfortable python interface to a C implementation of the
Ed25519 public-key signature system (http://ed25519.cr.yp.to/), using
the portable 'ref' code from the 'SUPERCOP' benchmarking suite.

This system provides high (128-bit) security, short (32-byte) keys,
short (64-byte) signatures, and fast (2-6ms) operation. Please see the
README for more details.

This package contains tests for %oname.

%prep
%setup
%patch0 -p1

touch 'version.py'
echo "%version" > version.py

%build
%python3_build_debug

%install
%python3_install

%check
%__python3 setup.py test

%files
%doc NEWS *.md
%_bindir/*
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*/test*
%exclude %python3_sitelibdir/*/*/test*

%files tests
%python3_sitelibdir/*/test*
%python3_sitelibdir/*/*/test*


%changelog
