%define oname fido

Name: python3-module-%oname
Version: 4.2.2
Release: alt2

Summary: Intelligent asynchronous HTTP client
License: ASLv2.0
Group: Development/Python3
Url: https://pypi.python.org/pypi/fido
BuildArch: noarch

# https://github.com/Yelp/fido.git
Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-twisted-core python3-module-crochet
BuildRequires: python3-module-service-identity python3-module-OpenSSL
BuildRequires: python3-module-coverage python3-module-flake8
BuildRequires: python3-module-mock python3-module-twisted-web
BuildRequires: python3(yelp_bytes) python3(constantly)
BuildRequires: python3-module-pytest

%py3_provides %oname
%py3_requires twisted.internet crochet service_identity OpenSSL
%py3_requires twisted.web concurrent.futures


%description
Fido is a simple, asynchronous HTTP client built on top of Crochet,
Twisted and concurrent.futures. It is intended to be used in
environments where there is no event loop, and where you cannot afford
to spin up lots of threads (otherwise you could just use a
ThreadPoolExecutor).

%prep
%setup

%build
%python3_build_debug

%install
%python3_install

%check
rm -f tests/0_import_reactor_test.py
rm -f tests/acceptance/fetch_test.py
py.test3

%files
%doc *.rst docs/source/*.rst
%python3_sitelibdir/*


%changelog
