%define oname flask-login

%def_disable check

Name: python3-module-%oname
Version: 0.3.0
Release: alt3

Summary: User session management for Flask
License: MIT
Group: Development/Python3
Url: https://pypi.python.org/pypi/Flask-Login/
# https://github.com/maxcountryman/flask-login.git
BuildArch: noarch

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-blinker python3-module-coverage
BuildRequires: python3-module-html5lib python3-module-nose
BuildRequires: python3-module-pbr python3-module-unittest2
BuildRequires: python3-pyflakes python3-tools-pep8


%description
Flask-Login provides user session management for Flask. It handles the
common tasks of logging in, logging out, and remembering your users'
sessions over extended periods of time.

Flask-Login is not bound to any particular database system or
permissions model. The only requirement is that your user objects
implement a few methods, and that you provide a callback to the
extension capable of loading users from their ID.

%prep
%setup

sed -i 's|nosetests|nosetests3|' ./run-tests.sh

%build
%python3_build_debug

%install
%python3_install

%check
python3 setup.py test

%files
%doc CHANGES README* docs/*.rst
%python3_sitelibdir/*


%changelog
