%define _unpackaged_files_terminate_build 1
%define pypi_name gitdb

%def_with check

Name: python3-module-%pypi_name
Version: 4.0.10
Release: alt1

Summary: IO of git-style object databases

License: BSD
Group: Development/Python3
Url: https://pypi.org/project/gitdb/
VCS: https://github.com/gitpython-developers/gitdb.git

BuildArch: noarch

Source: %name-%version.tar
Patch: %name-%version-alt.patch

BuildRequires(pre): rpm-build-python3

# build backend and its deps
BuildRequires: python3(setuptools)
BuildRequires: python3(wheel)

%if_with check
# install_requires=
BuildRequires: python3(smmap)

BuildRequires: python3(pytest)
BuildRequires: /usr/bin/git
%endif

%description
IO of git-style object databases.

%package tests
Summary: Tests for %pypi_name
Group: Development/Python3
Requires: %name = %EVR

%description tests
IO of git-style object databases.

This package contains tests for %pypi_name.

%prep
%setup
%autopatch -p1

%build
%pyproject_build

%install
%pyproject_install

# unbundle
rm -vr gitdb/ext/*

%check
# need git repo and objects, see gitdb/test/lib.py
git init
git config user.email "someone@somewhere.com"
git config user.name "someone"
git add -A
git commit -m "%version"

%tox_create_default_config
%tox_check_pyproject

%files
%doc AUTHORS *.rst
%python3_sitelibdir/gitdb/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/
%exclude %python3_sitelibdir/gitdb/test/

%files tests
%python3_sitelibdir/gitdb/test/

%changelog
