%define _unpackaged_files_terminate_build 1

%define oname greenlet

Name: python3-module-%oname
Version: 3.0.1
Release: alt1

Summary: Lightweight in-process concurrent programming

License: MIT
Group: Development/Python3
Url: http://pypi.python.org/pypi/greenlet

# Source-url: %__pypi_url %oname
Source: %oname-%version.tar

BuildRequires(pre): rpm-build-intro >= 2.2.5
BuildRequires(pre): rpm-build-python3
BuildRequires: gcc-c++

%description
The greenlet package is a spin-off of Stackless, a version of CPython
that supports micro-threads called "tasklets". Tasklets run
pseudo-concurrently (typically in a single or a few OS-level threads)
and are synchronized with data exchanges on "channels".

A "greenlet", on the other hand, is a still more primitive notion of
micro- thread with no implicit scheduling; coroutines, in other words.
This is useful when you want to control exactly when your code runs. You
can build custom scheduled micro-threads on top of greenlet; however, it
seems that greenlets are useful on their own as a way to make advanced
control flow structures. For example, we can recreate generators; the
difference with Python's own generators is that our generators can call
nested functions and the nested functions can yield values too.
Additionally, you don't need a "yield" keyword. See the example in
tests/test_generator.py.

Greenlets are provided as a C extension module for the regular
unmodified interpreter.

%package devel
Summary: C development headers for %name
Group:   Development/C
Requires: %name = %EVR

%description devel
%summary.

%prep
%setup -n %oname-%version

%build
%python3_build_debug

%install
%python3_install
%python3_prune

%check
%__python3 setup.py test -v

%files
%doc AUTHORS CHANGES.rst LICENSE* README*
%python3_sitelibdir/*

%files devel
%doc AUTHORS CHANGES.rst LICENSE* README*
%_includedir/python%_python3_version%_python3_abiflags/greenlet

%changelog
