%define _unpackaged_files_terminate_build 1
%define pypi_name PyHamcrest
%define mod_name hamcrest

%def_with check

Name: python3-module-%mod_name
Version: 2.1.0
Release: alt1
Summary: Hamcrest framework for matcher objects
License: BSD
Group: Development/Python3
Url: https://pypi.org/project/PyHamcrest/
Vcs: https://github.com/hamcrest/PyHamcrest
BuildArch: noarch
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch: %name-%version-alt.patch
%pyproject_runtimedeps_metadata
# mapping from PyPI name
Provides: python3-module-%{pep503_name %pypi_name} = %EVR
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
%add_pyproject_deps_check_filter 'pytest-mypy-plugins$'
%pyproject_builddeps_metadata_extra tests
%pyproject_builddeps_metadata_extra tests-numpy
%endif

%description
PyHamcrest is a framework for writing matcher objects, allowing you to
declaratively define "match" rules. There are a number of situations
where matchers are invaluable, such as UI validation, or data filtering,
but it is in the area of writing flexible tests that matchers are most
commonly used.

%prep
%setup
%autopatch -p1
%pyproject_scm_init
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_pytest -ra -Wignore

%files
%doc README.*
%python3_sitelibdir/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
