%define _unpackaged_files_terminate_build 1
%define oname ipwhois

%def_without check

Name: python3-module-%oname
Version: 1.2.0
Release: alt2

Summary: Retrieve and parse whois data for IPv4 and IPv6 addresses

License: BSD
Group: Development/Python3
Url: https://pypi.org/project/ipwhois/

BuildArch: noarch

# Source-url: %__pypi_url %oname
Source: %name-%version.tar

Patch2: fix-alt.patch

BuildRequires(pre): rpm-build-intro >= 2.2.5
BuildRequires(pre): rpm-build-python3

%if_with check
BuildRequires: python3(dns)
BuildRequires: python3(nose)
%endif

%description
ipwhois is a Python package focused on retrieving and parsing whois data
for IPv4 and IPv6 addresses.

Features:
* Parses a majority of whois fields in to a standard dictionary
* IPv4 and IPv6 support
* Referral whois support
* Supports REST queries (useful if whois is blocked from your network)
* Proxy support for REST queries
* Recursive network parsing for IPs with parent/children networks listed
* Python 2.6+ and 3.3+ supported
* Useful set of utilities
* BSD license

%prep
%setup
%patch2 -p1

%build
%python3_build

%install
%python3_install

%check
export NO_INTERNET=YES
nosetests3 -v -w ipwhois --exclude="(online|stress)"

%files
%doc *.rst
%_bindir/ipwhois_cli.py
%_bindir/ipwhois_utils_cli.py
%python3_sitelibdir/ipwhois/
%python3_sitelibdir/*.egg-info/

%changelog
