%define  modulename jaraco.functools

Name:    python3-module-%modulename
Version: 4.0.1
Release: alt0.p10.1

Summary: Additional functools in the spirit of stdlib's functools
License: MIT
Group:   Development/Python3
URL:     https://github.com/jaraco/jaraco.functools

Packager: Andrey Cherepanov <cas@altlinux.org>

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-dev
BuildRequires: python3-module-pyproject-installer
BuildRequires: python3-module-setuptools_scm
BuildRequires: python3-module-wheel

BuildArch: noarch

Source:  %modulename-%version.tar
Source1: setuptools-68.2.2-py3-none-any.whl

# According to PEP 420 module can import without __init__.py, but autoprov does not support this behaviour.
# See https://bugzilla.altlinux.org/show_bug.cgi?id=39556
%py3_provides jaraco.functools

# mapping from PyPI name
Provides: python3-module-%{pep503_name %modulename} = %EVR

%description
%summary

%prep
%setup -n %modulename-%version

%build
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
# https://bugzilla.altlinux.org/47647
# build with bundled setuptools
mkdir dist
cp %SOURCE1 dist/
echo "$(basename '%SOURCE1')" > dist/.wheeltracker
%pyproject_run -- bash -s <<-'ENDBUILD'
# redefine __python3 to python3 instead of /usr/bin/python3 to point to virt one
%global __python3_orig %__python3
%define __python3 python3
%pyproject_build
%define __python3 %__python3_orig
ENDBUILD

%install
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
%pyproject_install

%files
%python3_sitelibdir/jaraco/*
%python3_sitelibdir/%{modulename}*

%changelog
