%def_disable check

Name: python3-module-jedi
Version: 0.18.0
Release: alt1
Summary: An autocompletion tool for Python that can be used for text editors
License: MIT
Group: Development/Python
Url: https://pypi.python.org/pypi/jedi/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# https://github.com/davidhalter/jedi.git
Source: jedi-%version.tar.gz
BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-macros-sphinx3
# Automatically added by buildreq on Mon Feb 01 2021
# optimized out: ca-trust python-modules python-sphinx-objects.inv python2-base python3 python3-base python3-dev python3-module-Pygments python3-module-alabaster python3-module-babel python3-module-cffi python3-module-chardet python3-module-cryptography python3-module-docutils python3-module-idna python3-module-imagesize python3-module-jinja2 python3-module-markupsafe python3-module-openssl python3-module-packaging python3-module-pkg_resources python3-module-pytz python3-module-requests python3-module-sphinx python3-module-urllib3 sh4 xz
BuildRequires: ctags python3-module-setuptools python3-module-sphinx_rtd_theme python3-module-sphinxcontrib-applehelp python3-module-sphinxcontrib-devhelp python3-module-sphinxcontrib-htmlhelp python3-module-sphinxcontrib-jsmath python3-module-sphinxcontrib-qthelp python3-module-sphinxcontrib-serializinghtml

BuildRequires: python3-module-parso

%description
Jedi is an autocompletion tool for Python that can be used in
IDEs/editors. Jedi works. Jedi is fast. It understands all of the basic
Python syntax elements including many builtin functions.

Additionaly, Jedi suports two different goto functions and has support
for renaming as well as Pydoc support and some other IDE features.

%package pickles
Summary: Pickles for jedi
Group: Development/Python

%description pickles
Jedi is an autocompletion tool for Python that can be used in
IDEs/editors. Jedi works. Jedi is fast. It understands all of the basic
Python syntax elements including many builtin functions.

Additionaly, Jedi suports two different goto functions and has support
for renaming as well as Pydoc support and some other IDE features.

This package contains pickles for jedi.

%package docs
Summary: Documentation for jedi
Group: Development/Documentation
BuildArch: noarch

%description docs
Jedi is an autocompletion tool for Python that can be used in
IDEs/editors. Jedi works. Jedi is fast. It understands all of the basic
Python syntax elements including many builtin functions.

Additionaly, Jedi suports two different goto functions and has support
for renaming as well as Pydoc support and some other IDE features.

This package contains documentation for jedi.

%prep
%setup -n jedi-%version

sed -i 's|env python|env python3|' sith.py

ln -s ../objects.inv docs/

%build
%python3_build_debug

%prepare_sphinx3 .
%make -C docs pickle SPHINXBUILD=py3_sphinx-build BUILDDIR=_build3
%make -C docs html SPHINXBUILD=py3_sphinx-build BUILDDIR=_build3

%install
install -D -m755 sith.py %buildroot%_bindir/sith.py

%python3_install

cp -fR docs/_build3/pickle %buildroot%python3_sitelibdir/jedi/

%check
export LC_ALL=en_US.UTF-8
python3 setup.py test
rm -fR build
py.test-%_python3_version -vv

%files
%doc *.txt *.rst
%_bindir/*
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*/pickle

%files pickles
%python3_sitelibdir/*/pickle

%files docs
%doc docs/_build3/html/*

%changelog
