%define _unpackaged_files_terminate_build 1
%define oname joblib

%def_with check

Name: python3-module-%oname
Version: 0.14.1
Release: alt1

Summary: Lightweight pipelining: using Python functions as pipeline jobs
License: BSD
Group: Development/Python3
Url: http://pypi.python.org/pypi/joblib

BuildArch: noarch

# https://github.com/joblib/joblib.git
Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3

%if_with check
BuildRequires: /proc
BuildRequires: python3(numpy)
BuildRequires: python3(numpy.testing)
BuildRequires: python3(tox)
%endif

# `distributed` is not packaged yet
%filter_from_requires /python[3]\(\.[[:digit:]]\)\?(distributed\()\|\..*)\)/d

%description
Joblib is a set of tools to provide lightweight pipelining in Python. In
particular, joblib offers:

  1. transparent disk-caching of the output values and lazy
     re-evaluation (memoize pattern)
  2. easy simple parallel computing
  3. logging and tracing of the execution

Joblib is optimized to be fast and robust in particular on large data
and has specific optimizations for numpy arrays.

%package tests
Summary: Tests for joblib
Group: Development/Python3
Requires: %name = %version-%release

%description tests
Joblib is a set of tools to provide lightweight pipelining in Python. In
particular, joblib offers:

  1. transparent disk-caching of the output values and lazy
     re-evaluation (memoize pattern)
  2. easy simple parallel computing
  3. logging and tracing of the execution

Joblib is optimized to be fast and robust in particular on large data
and has specific optimizations for numpy arrays.

This package contains tests for joblib.

%prep
%setup

%build
%python3_build

%install
%python3_build_install

%check
%if 0
cat > tox.ini <<EOF
[testenv]
commands =
    {envpython} -m pytest {posargs:-vra}
EOF
export PIP_NO_INDEX=YES
export TOXENV=py%{python_version_nodots python3}
tox.py3 --sitepackages -p auto -o -vr
%endif

%files
%doc *.rst
%python3_sitelibdir/*
%exclude %python3_sitelibdir/%oname/test*
%exclude %python3_sitelibdir/%oname/__pycache__/test*

%files tests
%python3_sitelibdir/%oname/test*
%python3_sitelibdir/%oname/__pycache__/test*

%changelog
