%define _unpackaged_files_terminate_build 1

%define oname jupyter_core

%def_enable check

Name: python3-module-%oname
Version: 4.6.3
Release: alt2
Summary: Jupyter core package
License: BSD-3-Clause
Group: Development/Python3
BuildArch: noarch
Url: https://pypi.org/project/jupyter-core

# https://github.com/jupyter/jupyter_core.git
Source: %name-%version.tar

Patch1: %oname-%version-alt-tests.patch
Patch2: CVE-2022-39286.patch

BuildRequires(pre): rpm-macros-sphinx3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-zope python3-module-pytest python3(traitlets.config) python3(mock)
BuildRequires: python3(ipython_genutils.testing)
BuildRequires: python3(sphinxcontrib_github_alt)
BuildRequires: python3-module-sphinx-sphinx-build-symlink

%description
Jupyter core package. A base package on which Jupyter projects rely.

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR

%description tests
Jupyter core package. A base package on which Jupyter projects rely.

This package contains tests for %oname.

%prep
%setup
%patch1 -p1
%patch2 -p1

%prepare_sphinx3 .
ln -s ../objects.inv docs/

%build
%python3_build_debug

%install
%python3_install

export PYTHONPATH=%buildroot%python3_sitelibdir
%make -C docs html

%check
rm -fR build
export NOT_INSTALLED=true
LC_ALL=en_US.UTF-8 PYTHONPATH=%buildroot%python3_sitelibdir py.test3 -vv

%files
%doc *.md docs/_build/html
%_bindir/*
%python3_sitelibdir/jupyter.py
%python3_sitelibdir/__pycache__/jupyter.*
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version-py*.egg-info
%exclude %python3_sitelibdir/%oname/tests

%files tests
%python3_sitelibdir/%oname/tests

%changelog
