%global pypi_name mox3
%def_disable check

Name: python3-module-%pypi_name
Version: 1.0.0
Release: alt2
Summary: Mock object framework for Python
License: Apache-2.0
Group: Development/Python3
Url: http://docs.openstack.org/developer/%pypi_name
Source: https://tarballs.openstack.org/%pypi_name/%pypi_name-%version.tar.gz

BuildArch:      noarch

BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-macros-sphinx3
BuildRequires: python3-devel
BuildRequires: python3-module-pbr >= 2.0.0
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-sphinx
BuildRequires: python3-module-openstackdocstheme >= 1.18.1
BuildRequires: python3-module-reno
BuildRequires: python3-module-fixtures >= 3.0.0
BuildRequires: python3-module-testtools
BuildRequires: python3-module-mimeparse
BuildRequires: python3-module-extras
BuildRequires: python3-module-testrepository
BuildRequires: python3-module-subunit
BuildRequires: python3-module-discover
BuildRequires: python3-module-coverage
BuildRequires: python3-module-hacking
BuildRequires: python3-module-d2to1
BuildRequires: python3-module-flake8
BuildRequires: python3-pyflakes
BuildRequires: python3-tools-pep8
BuildRequires: python3-module-requests

%py3_provides %pypi_name

%description
Mox3 is an unofficial port of the Google mox framework
(http://code.google.com/p/pymox/) to Python 3. It was meant to be as compatible
with mox as possible, but small enhancements have been made. The library was
tested on Python version 3.2, 2.7 and 2.6.

%package tests
Summary: Tests for %pypi_name
Group: Development/Python3
Requires: %name = %EVR

%description tests
Mox3 is an unofficial port of the Google mox framework
(http://code.google.com/p/pymox/) to Python 3. It was meant to be as compatible
with mox as possible, but small enhancements have been made. The library was
tested on Python version 3.2, 2.7 and 2.6.

This package contains tests for %pypi_name.

%package pickles
Summary: Pickles for %pypi_name
Group: Development/Python3

%description pickles
Mox3 is an unofficial port of the Google mox framework
(http://code.google.com/p/pymox/) to Python 3. It was meant to be as compatible
with mox as possible, but small enhancements have been made. The library was
tested on Python version 3.2, 2.7 and 2.6.

This package contains pickles for %pypi_name.

%prep
%setup -n %pypi_name-%version


%prepare_sphinx3 doc
ln -s ../objects.inv doc/source/

%build
%python3_build

%install
%python3_install

export PYTHONPATH=%buildroot%python3_sitelibdir
pushd doc/source
export PBR_VERSION=$(pbr.py3 --version)
sphinx-build-3 -b pickle -d build/doctrees . build/pickle
sphinx-build-3 -b html -d build/doctrees . build/html
cp -fR build/pickle %buildroot%python3_sitelibdir/%pypi_name/
popd

%check
python3 setup.py test
rm -fR build
py.test3

%files
%doc COPYING.txt ChangeLog AUTHORS README.rst doc/source/build/html
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*/tests
%exclude %python3_sitelibdir/*/pickle

%files pickles
%python3_sitelibdir/*/pickle

%files tests
%python3_sitelibdir/*/tests

%changelog
