%define mpiimpl openmpi
%define mpidir %_libdir/%mpiimpl
%define oname mpi4py

Name: python3-module-%oname
Version: 2.0.0
Release: alt4.a0.git20150528
Summary: MPI bindings for Python
License: Public
Group: Development/Python3
Url: http://www.cimec.org.ar/python/

# https://bitbucket.org/mpi4py/mpi4py.git
Source: %oname-%version.tar.gz

BuildRequires(pre): rpm-macros-make
BuildRequires(pre): rpm-build-python3
BuildRequires: openmpi-devel python3-module-zope
BuildRequires: python3-module-Cython

%description
This package is constructed on top of the MPI-1
specification and provides an object oriented interface
which closely follows MPI-2 C++ bindings. It supports
point-to-point (sends, receives) and collective
(broadcasts, scatters, gathers) communications of any
*picklable* Python object.

%package devel
Summary: Headers of MPI bindings for Python 3
Group: Development/Python3
Requires: python3-module-%oname = %version-%release
Requires: %mpiimpl-devel

%description devel
This package is constructed on top of the MPI-1
specification and provides an object oriented interface
which closely follows MPI-2 C++ bindings. It supports
point-to-point (sends, receives) and collective
(broadcasts, scatters, gathers) communications of any
*picklable* Python object.

This package contains headers of MPI bindings for Python.

%package doc
Summary: Documentation for mpi4py, MPI bindings for Python
Group: Development/Documentation
BuildArch: noarch

%description doc
Documentation for mpi4py, MPI bindings for Python.

%prep
%setup

%build
source %mpidir/bin/mpivars.sh
export OMPI_LDFLAGS="-Wl,--as-needed,-rpath,%mpidir/lib -L%mpidir/lib"

sed -i 's|(MPIDIR)|%mpidir|' setup.cfg
%define optflags %optflags_default
unset CFLAGS
unset CXXFLAGS
unset FFLAGS
%add_optflags -I%mpidir/include -I%_includedir/python%_python3_version
sed -i 's|^PYTHON.*|PYTHON = python3|' makefile
%make_ext config
%make_build_ext

%install
source %mpidir/bin/mpivars.sh
export OMPI_LDFLAGS="-Wl,--as-needed,-rpath,%mpidir/lib -L%mpidir/lib"
export PATH=$PATH:%mpidir/bin

OPTFLAGS="%optflags -I%mpidir/include -I%_includedir/python%_python3_version"
export CFLAGS="${OPTFLAGS}"
export CXXFLAGS="${OPTFLAGS}"
export FFLAGS="${OPTFLAGS}"
%python3_install --optimize=2

install -d %buildroot%_docdir/%name
cp -fR docs/source %buildroot%_docdir/%name/

%files
%doc *.rst
%python3_sitelibdir/*
%exclude %python3_sitelibdir/%oname/include

%files devel
%python3_sitelibdir/%oname/include

%files doc
%_docdir/%name

%changelog
