%global pypi_name netaddr
%def_enable check

Name:		python3-module-%{pypi_name}
Version:	0.7.19
Release:	alt2
Summary:	A pure Python network address representation and manipulation library

Group:		Development/Python3
License:	BSD
URL:		http://github.com/drkjam/netaddr
# Source0-url: https://github.com/drkjam/netaddr/archive/netaddr-%version.tar.gz
Source0:	%name-%version.tar
BuildArch: noarch

Patch0001: 0001-fixed-broken-tests.patch
Patch0002: 0002-PEP-479-return-instead-of-raise-StopIteration.patch
Patch0003: 0003-Use-raw-strings-for-escape-characters-used-in-regex.patch
Patch0004: 0004-fix-Python-38-SyntaxWarning-on-using-is-not-with-a-string-literal.patch
Patch0005: 0005-Do-not-override-executable-path.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-sphinx
%{?_enable_check:BuildRequires: python3-module-pytest}

%description
A pure Python network address representation and manipulation library.

netaddr provides a Pythonic way of working with :-

- IPv4 and IPv6 addresses and subnets
- MAC addresses, OUI and IAB identifiers, IEEE EUI-64 identifiers
- arbitrary (non-aligned) IP address ranges and IP address sets
- various non-CIDR IP range formats such as nmap and glob-style formats

Included are routines for :-

- generating, sorting and summarizing IP addresses and networks
- performing easy conversions between address notations and formats
- detecting, parsing and formatting network address representations
- performing set-based operations on groups of IP addresses and subnets
- working with arbitrary IP address ranges and formats
- accessing OUI and IAB organisational information published by IEEE
- accessing IP address and block information published by IANA

For details on the latest updates and changes, see :-

    http://github.com/drkjam/netaddr/blob/rel-0.7.x/CHANGELOG

API documentation for the latest release is available here :-

    http://packages.python.org/netaddr/


%prep
%setup
%patch0001 -p1
%patch0002 -p1
%patch0003 -p1
%patch0004 -p1
%patch0005 -p1

# Make rpmlint happy, get rid of DOS line endings
%{__sed} -i 's/\r//' netaddr/*.py
%{__sed} -i 's/\r//' netaddr/ip/*.py
%{__sed} -i 's/\r//' netaddr/eui/*.idx

# Make rpmlint happy, rip out python shebang lines from most python
# modules
find netaddr -name "*.py" | \
  xargs sed -i -e '1 {/^#!\//d}'
# Fix python executable
sed -i -e '1s,/usr/bin/env python,%__python3,' netaddr/tools/netaddr

# Make rpmlint happy, fix permissions on documentation files
chmod 0644 AUTHORS CHANGELOG COPYRIGHT INSTALL LICENSE REFERENCES THANKS

%build
%python3_build


#docs
pushd docs
PYTHONPATH='../' sphinx-build-3 -b html -d build/doctrees source html
popd

%install
%python3_install

%check
py.test3

%files
%doc AUTHORS CHANGELOG COPYRIGHT LICENSE REFERENCES THANKS
%doc README.md docs/html
%python3_sitelibdir/*
%_bindir/netaddr

%changelog
