%define oname notebook

#%def_disable check
%def_without bootstrap

%def_without doc

Name: python3-module-%oname
Version: 6.1.4
Release: alt1

Summary: Jupyter Interactive Notebook
License: BSD
Group: Development/Python3

Url: https://pypi.python.org/pypi/notebook/

# Source-url: %__pypi_url %oname
Source: %name-%version.tar

BuildArch: noarch

BuildRequires(pre): rpm-build-intro
BuildRequires(pre): rpm-build-python3

%if_with doc
BuildRequires: pandoc
%endif

BuildRequires: python3-devel >= 3.5
BuildRequires: python3-module-setuptools
%if_with bootstrap
BuildRequires: python3-module-ipython_genutils-tests
%endif
BuildRequires: python3-module-traitlets-tests
%if_with bootstrap
%py3_use nbconvert
%py3_use ipykernel
%endif
BuildRequires: python3-module-mock
BuildRequires: python3-module-nose python3-module-requests
BuildRequires: python3-module-coverage
%{?!_without_check:%{?!_disable_check:BuildRequires: python3(pandocfilters) python3(nose_warnings_filters)}}
%if_with doc
BuildRequires: python3-module-sphinx-devel
BuildRequires: python3(nbsphinx) python3-module-sphinx_rtd_theme
%endif

%py3_use zmq >= 17
%py3_use argon2-cffi
%py3_use jinja2
%py3_use tornado >= 5.0
%py3_use ipython_genutils
%py3_use traitlets >= 4.2.1
%py3_use jupyter_core >= 4.6.1
%py3_use jupyter_client >= 5.3.4
%py3_use terminado >= 0.8.3
%py3_use nbformat

Conflicts: python-module-%oname

%description
The Jupyter HTML notebook is a web-based notebook environment for
interactive computing.

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR

%description tests
The Jupyter HTML notebook is a web-based notebook environment for
interactive computing.

This package contains tests for %oname.

%package pickles
Summary: Pickles for %oname
Group: Development/Python3

%description pickles
The Jupyter HTML notebook is a web-based notebook environment for
interactive computing.

This package contains pickles for %oname.

%package docs
Summary: Documentation for %oname
Group: Development/Documentation
BuildArch: noarch

%description docs
The Jupyter HTML notebook is a web-based notebook environment for
interactive computing.

This package contains documentation for %oname.


%prep
%setup

%if_with doc
%prepare_sphinx3 docs
ln -s ../objects.inv ../python3/docs/source/
%endif

%build
%python3_build_debug

%install
%python3_install

%if_with doc
export PYTHONPATH=$PWD
%make -C docs pickle SPHINXBUILD=py3_sphinx-build
%make -C docs html SPHINXBUILD=py3_sphinx-build
cp -fR docs/build/pickle %buildroot%python3_sitelibdir/%oname/
%endif

%if_with bootstrap
%check
nosetests3 -vv --with-coverage --cover-package=%oname %oname
%endif

%files
%doc *.md
%_bindir/jupyter-bundlerextension
%_bindir/jupyter-nbextension
%_bindir/jupyter-notebook
%_bindir/jupyter-serverextension
%python3_sitelibdir/%oname/
%python3_sitelibdir/%oname-*.egg-info
%exclude %python3_sitelibdir/*/tests
%exclude %python3_sitelibdir/*/*/tests
%exclude %python3_sitelibdir/*/*/*/tests
%if_with doc
%exclude %python3_sitelibdir/%oname/pickle
%endif

%files tests
%python3_sitelibdir/*/tests
%python3_sitelibdir/*/*/tests
%python3_sitelibdir/*/*/*/tests

%if_with doc
%files pickles
%python3_sitelibdir/%oname/pickle/

%files docs
%doc ../python3/docs/build/html/*
%endif

%changelog
