%define oname numdifftools

%def_disable check

Name: python3-module-%oname
Version: 0.9.39
Release: alt2

Summary: Solves automatic numerical differentiation problems in one or more variables

License: BSD
Group: Development/Python3
Url: https://github.com/pbrod/numdifftools

# Source-url: %__pypi_url %oname
Source: %name-%version.tar

BuildRequires(pre): rpm-build-intro >= 2.2.5
BuildRequires(pre): rpm-build-python3
BuildPreReq: python3-devel python3-module-scipy
BuildPreReq: python3-module-numpy python3-module-matplotlib
BuildPreReq: python3-module-coverage python3-module-setuptools
BuildPreReq: python3-module-setuptools_scm python3-module-six
BuildPreReq: python3-module-algopy
BuildRequires: python3-module-pytest-runner
%if_enabled check
BuildPreReq: python3-module-nose xvfb-run
BuildPreReq: python3-module-pytest-cov
%endif
BuildPreReq: texlive-latex-recommended

%py3_provides %oname
%py3_requires numpy scipy algopy

%description
Numdifftools is a suite of tools to solve automatic numerical
differentiation problems in one or more variables. All of these methods
also produce error estimates on the result.

%prep
%setup

%build
%python3_build_debug

%install
%python3_install
%python3_prune

%if "%_libexecdir" != "%_libdir"
mv %buildroot%_libexecdir %buildroot%_libdir
%endif

%check
%if_enabled check
export PYTHONPATH=%buildroot%python3_sitelibdir
pushd ~
xvfb-run python3 -c "import numdifftools as nd; nd.test(coverage=True)" || :
popd
xvfb-run py.test-%_python3_version -vv -rsxXf
%endif

%files
%python3_sitelibdir/*

%changelog
