%def_with check
%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

%ifarch %ix86 ppc64le armh
%define relax_tests 1
%endif

# LTO causes errors, disable it
%global optflags_lto %nil

%define oname numpy

Name: python3-module-%oname
Epoch: 1
Version: 1.21.4
Release: alt2.p10.1
Summary: NumPy: array processing for numbers, strings, records, and objects
License: BSD-3-Clause
Group: Development/Python3
Url: https://www.numpy.org/

# VCS: https://github.com/numpy/numpy.git
Source: %name-%version.tar
Source2: site.cfg

Patch: numpy-1.20.2-Remove-strict-dependency-on-testing-package.patch
Patch1: numpy-1.21.1-alt-use-system-fallocate-declaration.patch
Patch2: numpy-1.21.1-alt-recfunctions-use-warnings-instead-of-suppress_warnings.patch
Patch3: numpy-1.21.4-upstream-fix-generic-aliases-tests.patch
Patch4: numpy-1.21.4-alt-use-sleep-in-auxv-test.patch
Patch5: numpy-1.21.4-alt-fix-tests-to-build-with-hypothesis-6.82.3.patch

# E2K patchset with MCST numbering scheme
Patch1001: 0001-arch_e2k_define.patch
Patch1002: 0002-bug92804.patch
Patch1003: 0003-lcc-1.24-compat.patch

BuildRequires(pre): rpm-macros-sphinx3
BuildRequires(pre): rpm-build-python3
BuildRequires: /proc
BuildRequires: gcc-c++ gcc-fortran liblapack-devel swig
BuildRequires: python3-module-Cython
%{?_with_check:BuildRequires: python3-module-pytest python3-module-hypothesis}

# Remove deps that are self provided
%add_python3_req_skip __version__ distutils.msvc9compiler distutils.msvccompiler setup_common
# https://bugzilla.altlinux.org/show_bug.cgi?id=18379
%add_python3_req_skip Scons setuptools distutils nose number code_generators
# See bug 35103
%add_python3_req_skip setuptools.command.develop setuptools.command.egg_info
%add_python3_req_skip code_generators.genapi code_generators.numpy_api genapi numpy._build_utils.apple_accelerate numpy_api

%add_findprov_skiplist %python3_sitelibdir/%oname/random/_examples/*
%add_findreq_skiplist  %python3_sitelibdir/%oname/random/_examples/*

Conflicts: python-module-numpy < 1:1.15.4-alt6

%description
NumPy is a general-purpose array-processing package designed to
efficiently manipulate large multi-dimensional arrays of arbitrary
records without sacrificing too much speed for small multi-dimensional
arrays.  NumPy is built on the Numeric code base and adds features
introduced by numarray as well as an extended C-API and the ability to
create arrays of arbitrary type.

There are also basic facilities for discrete fourier transform,
basic linear algebra and random number generation.

%package testing
Summary: Testing part of NumPy (Python 3)
Group: Development/Python3
Requires: %name = %EVR
%add_python3_req_skip setuptools

%description testing
NumPy is a general-purpose array-processing package designed to
efficiently manipulate large multi-dimensional arrays of arbitrary
records without sacrificing too much speed for small multi-dimensional
arrays.  NumPy is built on the Numeric code base and adds features
introduced by numarray as well as an extended C-API and the ability to
create arrays of arbitrary type.

This package contains testing part of NumPy.

%package tests
Summary: Tests for NumPy (Python 3)
Group: Development/Python3
Requires: %name = %EVR
%add_python3_req_skip core scipy

%description tests
NumPy is a general-purpose array-processing package designed to
efficiently manipulate large multi-dimensional arrays of arbitrary
records without sacrificing too much speed for small multi-dimensional
arrays.  NumPy is built on the Numeric code base and adds features
introduced by numarray as well as an extended C-API and the ability to
create arrays of arbitrary type.

This package contains tests NumPy.

%package -n lib%oname-py3-devel
Summary: Development files of NumPy (Python 3)
Group: Development/Python3
Requires: %name = %EVR
Requires: python3-devel

%description -n lib%oname-py3-devel
NumPy is a general-purpose array-processing package designed to
efficiently manipulate large multi-dimensional arrays of arbitrary
records without sacrificing too much speed for small multi-dimensional
arrays.  NumPy is built on the Numeric code base and adds features
introduced by numarray as well as an extended C-API and the ability to
create arrays of arbitrary type.

This package contains development files of NumPy.

%package pickles
Summary: Pickles for NumPy
Group: Development/Python3

%description pickles
NumPy is a general-purpose array-processing package designed to
efficiently manipulate large multi-dimensional arrays of arbitrary
records without sacrificing too much speed for small multi-dimensional
arrays.  NumPy is built on the Numeric code base and adds features
introduced by numarray as well as an extended C-API and the ability to
create arrays of arbitrary type.

This package contains pickles for NumPy.

%prep
%setup
%patch -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1

%ifarch %e2k
%patch1001 -p1
%patch1002 -p1
%patch1003 -p1
%endif

install -m644 %SOURCE2 .
sed -i 's|@LIBDIR@|%_libdir|g' site.cfg
sed -i 's|@PYVER@|%_python3_version|g' site.cfg doc/Makefile
sed -i 's|@PYSUFF@|3|' site.cfg

%ifarch mipsel
sed -i 's|@BLAS@|blas|' site.cfg
%else
sed -i 's|@BLAS@|openblas|' site.cfg
%endif

# headers
sed -i 's|^prefix.*|prefix=%python3_sitelibdir/%oname/core|' \
	%oname/core/npymath.ini.in
sed -i 's|^includedir.*|includedir=%_includedir/python%_python3_version/%oname|' \
	%oname/core/npymath.ini.in

# fix version info
sed -i \
	-e "s/git_refnames\s*=\s*\"[^\"]*\"/git_refnames = \" \(tag: v%version\)\"/" \
	%oname/_version.py

%build
INCS="-I%_includedir/suitesparse -I$PWD/numpy/core/include/numpy"
INCS="$INCS -I$PWD/numpy/core/include -I%buildroot%_includedir/python%_python3_version/%oname"
INCS="$INCS -I%buildroot%_includedir"
DEFS="-DHAVE_FREXPF -DHAVE_FREXPL -DHAVE_FREXP -DHAVE_LDEXP -DHAVE_LDEXPL"
DEFS="$DEFS -DHAVE_EXPM1 -DHAVE_LOG1P -DHAVE_LDEXPF"
DEFS="$DEFS -UNPY_CPU_AMD64 -UNPY_CPU_X86"
%add_optflags -fno-strict-aliasing $DEFS $INCS %optflags_shared

%python3_build_debug --fcompiler=gnu95

%check
python3 runtests.py -v %{?relax_tests:||:}

%install
INCS="-I%_includedir/suitesparse -I$PWD/numpy/core/include/numpy"
INCS="$INCS -I$PWD/numpy/core/include -I%buildroot%_includedir/python%_python3_version/%oname"
INCS="$INCS -I%buildroot%_includedir"
DEFS="-DHAVE_FREXPF -DHAVE_FREXPL -DHAVE_FREXP -DHAVE_LDEXP -DHAVE_LDEXPL"
DEFS="$DEFS -DHAVE_EXPM1 -DHAVE_LOG1P -DHAVE_LDEXPF"
DEFS="$DEFS -UNPY_CPU_AMD64 -UNPY_CPU_X86"
DEFS="$DEFS -DNPY_ENABLE_SEPARATE_COMPILATION"
%add_optflags -fno-strict-aliasing $DEFS $INCS %optflags_shared

%python3_build_install

# private headers

install -d %buildroot%_includedir/python%_python3_version
mv %buildroot%python3_sitelibdir/%oname/core/include/%oname \
	%buildroot%_includedir/python%_python3_version/%oname

install -d %buildroot%python3_sitelibdir/%oname/core/include
ln -s %_includedir/python%_python3_version/%oname \
	%buildroot%python3_sitelibdir/%oname/core/include/
cp build/src.*/%oname/core/include/%oname/{*.h,*.c} \
	%buildroot%_includedir/python%_python3_version/%oname/
install -d %buildroot%python3_sitelibdir/%oname/core/lib/npy-pkg-config
cp -fR build/src.*/%oname/core/lib/npy-pkg-config/* \
	%buildroot%python3_sitelibdir/%oname/core/lib/npy-pkg-config/

%files
%doc LICENSE.txt
%doc README.md THANKS.txt
%_bindir/f2py*
%python3_sitelibdir/%oname
%exclude %python3_sitelibdir/%oname/conftest.py
%exclude %python3_sitelibdir/%oname/_pytesttester.py
%exclude %python3_sitelibdir/%oname/__pycache__/conftest.*
%exclude %python3_sitelibdir/%oname/__pycache__/_pytesttester.*
%exclude %python3_sitelibdir/%oname/f2py/f2py_testing.py
%exclude %python3_sitelibdir/%oname/f2py/__pycache__/f2py_testing.*
%exclude %python3_sitelibdir/%oname/ma/timer_comparison.py
%exclude %python3_sitelibdir/%oname/ma/__pycache__/timer_comparison.*
%exclude %python3_sitelibdir/%oname/testing
%exclude %python3_sitelibdir/%oname/tests
%exclude %python3_sitelibdir/%oname/*/test*
%exclude %python3_sitelibdir/%oname/*/*/test*
%exclude %python3_sitelibdir/%oname/f2py/src/fortranobject.h
%exclude %python3_sitelibdir/%oname/core/lib/npy-pkg-config
%exclude %python3_sitelibdir/%oname/doc
%exclude %python3_sitelibdir/%oname/core/include
%exclude %python3_sitelibdir/%oname/distutils/mingw
%exclude %python3_sitelibdir/%oname/f2py/src
%exclude %python3_sitelibdir/%oname/core/lib/libnpymath.a
%exclude %python3_sitelibdir/%oname/random/lib/libnpyrandom.a
%python3_sitelibdir/%oname-%version-*.egg-info

%files testing
%python3_sitelibdir/%oname/testing
%python3_sitelibdir/%oname/conftest.py
%python3_sitelibdir/%oname/_pytesttester.py
%python3_sitelibdir/%oname/__pycache__/conftest.*
%python3_sitelibdir/%oname/__pycache__/_pytesttester.*

%files tests
%python3_sitelibdir/%oname/tests
%python3_sitelibdir/%oname/*/test*
%python3_sitelibdir/%oname/*/*/test*
%exclude %python3_sitelibdir/%oname/testing/tests
%python3_sitelibdir/%oname/f2py/tests/src/array_from_pyobj

%files -n lib%oname-py3-devel
%_includedir/python%_python3_version/%oname
%python3_sitelibdir/%oname/core/include
%python3_sitelibdir/%oname/distutils/mingw
%exclude %python3_sitelibdir/%oname/distutils/tests
%python3_sitelibdir/%oname/f2py/src
%python3_sitelibdir/%oname/core/lib/npy-pkg-config
%python3_sitelibdir/%oname/core/lib/libnpymath.a
%python3_sitelibdir/%oname/random/lib/libnpyrandom.a

%changelog
