%define oname octaviaclient

%def_without tests
%def_without doc

Name:       python3-module-%oname
Version:    3.4.0
Release:    alt1.p10

Summary:    Octavia client for OpenStack Load Balancing

Group:      Development/Python3
License:    Apache-2.0
Url:        http://docs.openstack.org/developer/%oname

Source:     https://tarballs.openstack.org/python-%oname/python-%oname-%version.tar.gz

BuildArch:  noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
BuildRequires: python3-module-cliff >= 2.8.0
BuildRequires: python3-module-keystoneauth1 >= 3.18.0
BuildRequires: python3-module-neutronclient >= 6.7.0
BuildRequires: python3-module-openstackclient >= 3.12.0
BuildRequires: python3-module-osc-lib >= 1.14.1
BuildRequires: python3-module-oslo.serialization >= 2.18.0
BuildRequires: python3-module-oslo.utils >= 3.33.0
BuildRequires: python3-module-pbr >= 2.0.0
BuildRequires: python3-module-requests >= 2.14.2

%if_with tests
BuildRequires: python3-module-hacking >= 3.0.1 python3-module-hacking < 3.1.0
BuildRequires: python3-module-requests-mock >= 1.2.0
BuildRequires: python3-module-coverage >= 4.0
BuildRequires: python3-module-doc8 >= 0.6.0
BuildRequires: python3-module-Pygments >= 2.2.0
BuildRequires: python3-module-bandit >= 1.1.0
BuildRequires: python3-module-flake8-import-order == 0.12
BuildRequires: python3-module-pylint >= 2.5.3
BuildRequires: python3-module-subunit >= 1.0.0
BuildRequires: python3-module-oslotest >= 3.2.0
BuildRequires: python3-module-stestr >= 2.0.0
BuildRequires: python3-module-testscenarios >= 0.4
%endif

%if_with doc
BuildRequires: python3-module-sphinx >= 2.0.0
BuildRequires: python3-module-openstackdocstheme >= 2.2.1
BuildRequires: python3-module-reno >= 3.1.0
BuildRequires: python3-module-sphinxcontrib-svg2pdfconverter >= 0.1.0
%endif

%description
This is an OpenStack Client (OSC) plugin for Octavia, an OpenStack
Load Balancing project.

Requires: python3-module-cliff >= 4.1.0 python3-module-cliff <= 4.2.0
Requires: python3-module-keystoneauth1 >= 5.1.0 python3-module-keystoneauth1 <= 5.1.2
Requires: python3-module-neutronclient >= 8.2.0 python3-module-neutronclient <= 9.0.0
Requires: python3-module-openstackclient >= 6.1.0 python3-module-openstackclient <= 6.2.0
Requires: python3-module-osc-lib = 2.7.0
Requires: python3-module-oslo.serialization >= 5.1.0 python3-module-oslo.serialization <= 5.1.1
Requires: python3-module-oslo.utils = 6.1.0
Requires: python3-module-pbr >= 2.0.0
Requires: python3-module-requests >= 2.14.2

%if_with tests
%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR

%description tests
This package contains tests for %oname.
%endif

%if_with doc
%package doc
Summary: Documentation for OpenStack Octavia client
Group: Development/Documentation

%description doc
This is an OpenStack Client (OSC) plugin for Octavia, an OpenStack
Load Balancing project.

This package contains documentation for %oname.
%endif

%prep
%setup -n python-%oname-%version

# Let RPM handle the dependencies
rm -f {,test-}requirements.txt

# Prevent doc build warnings from causing a build failure
sed -i '/warning-is-error/d' setup.cfg

%build
export PBR_VERSION=%version
%pyproject_build

export PYTHONPATH="$PWD"

%if_with doc
# generate html docs
sphinx-build-3 doc/source html
# generate man page
sphinx-build-3 -b man doc/source man
# remove the sphinx-build leftovers
rm -rf html/.{doctrees,buildinfo}
%endif

%install
%pyproject_install

%if_with doc
# install man page
install -p -D -m 644 man/python-octaviaclient.1 %buildroot%_man1dir/octaviaclient.1
%endif

%files
#%doc *.rst LICENSE
#%_man1dir/octaviaclient*
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*/tests

%if_with tests
%files tests
%python3_sitelibdir/*/tests
%endif

%if_with doc
%files doc
%doc LICENSE html
%endif

%changelog
