%define     oname openstackdocstheme

%def_with docs
# problems with hacking < 3.1.0
%def_without check

Name:       python3-module-%oname
Version:    2.3.0
Release:    alt1

Summary:    Sphinx theme for RST-sourced documentation published to docs.openstack.org

License:    Apache-2.0
Group:      Development/Python3
Url:        https://pypi.org/project/openstackdocstheme
#           https://github.com/openstack/openstackdocstheme

Packager:   Grigory Ustinov <grenka@altlinux.org>

Source:     %name-%version.tar

BuildArch:  noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-pbr

%if_with docs
BuildRequires: python3-module-sphinx
BuildRequires: python3-module-dulwich
%endif

%if_with check
BuildRequires: python3-module-pip
BuildRequires: python3-module-pre-commit
BuildRequires: python3-module-hacking
%endif

%description
OpenStack Sphinx Theme

Theme and extension support for Sphinx documentation that is published to
docs.openstack.org. Intended for use by OpenStack projects.

%package doc
Summary:    %oname documentation
Group:      Development/Documentation
%description doc
Documentation for %oname

%prep
%setup

# Prevent doc build warnings from causing a build failure
sed -i '/warning-is-error/d' setup.cfg

%build
%python3_build

%if_with docs
export PYTHONPATH=.
sphinx-build-3 -b html doc/source doc/build/html
# remove the sphinx-build leftovers
rm -rf html/.{doctrees,buildinfo}
%endif

%install
%python3_install
mkdir -p %buildroot%python3_sitelibdir_noarch/%oname/theme
cp -r %oname/theme/* \
%buildroot%python3_sitelibdir_noarch/%oname/theme

%check
python3 setup.py test

%files
%doc README.rst
%_bindir/docstheme-build-pdf
%_bindir/docstheme-build-translated.sh
%_bindir/docstheme-lang-display-name.py
%python3_sitelibdir_noarch/%oname
%python3_sitelibdir_noarch/*.egg-info

%if_with docs
%files doc
%doc doc/build/html
%endif

%changelog
