%define oname osc-lib
%def_with check
%def_with docs

Name: python3-module-%oname
Version: 2.7.0
Release: alt1.1.p10

Summary: OpenStackClient Library

License: Apache-2.0
Group: Development/Python3
Url: https://pypi.org/project/osc-lib

Source: %oname-%version.tar
Source1: %oname.watch

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
BuildRequires: python3-module-pbr >= 2.0.0
BuildRequires: python3-module-cliff >= 3.2.0
BuildRequires: python3-module-keystoneauth1 >= 3.14.0
BuildRequires: python3-module-openstacksdk >= 0.15.0
BuildRequires: python3-module-oslo.i18n >= 3.15.3
BuildRequires: python3-module-oslo.utils >= 3.33.0
BuildRequires: python3-module-simplejson >= 3.5.1
BuildRequires: python3-module-stevedore >= 1.20.0

%if_with check
BuildRequires: python3-module-coverage >= 4.0
BuildRequires: python3-module-fixtures >= 3.0.0
BuildRequires: python3-module-stestr >= 1.0.0
BuildRequires: python3-module-testtools >= 2.2.0
BuildRequires: python3-module-oslotest >= 3.2.0
BuildRequires: python3-module-requests-mock >= 1.1.0
BuildRequires: python3-module-osprofiler >= 1.4.0
%endif

%if_with docs
BuildRequires: python3-module-sphinx
BuildRequires: python3-module-sphinxcontrib-apidoc
BuildRequires: python3-module-openstackdocstheme >= 1.18.1
%endif

Requires: python3-module-pbr >= 2.0.0
Requires: python3-module-cliff >= 4.1.0 python3-module-cliff <= 4.2.0
Requires: python3-module-keystoneauth1 >= 5.1.0 python3-module-keystoneauth1 <= 5.1.2
Requires: python3-module-openstacksdk >= 0.102.0 python3-module-openstacksdk <= 1.0.1
Requires: python3-module-oslo.i18n = 6.0.0
Requires: python3-module-oslo.utils = 6.1.0
Requires: python3-module-simplejson >= 3.5.1
Requires: python3-module-stevedore >= 4.1.0 python3-module-stevedore <= 5.0.0

%description
OpenStackClient (aka OSC) is a command-line client for OpenStack.
osc-lib is a package of common support modules for writing OSC plugins.

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR

%description tests
This package contains tests for %oname.

%if_with docs
%package doc
Summary: Documentation for %oname
Group: Development/Documentation

%description doc
This package contains documentation for %oname.
%endif

%prep
%setup -n %oname-%version

# Remove bundled egg-info
rm -rfv *.egg-info

%build
%pyproject_build

%if_with docs
export PYTHONPATH="$PWD"
# generate html docs
sphinx-build-3 doc/source html
# generate man page
sphinx-build-3 -b man doc/source man
# remove the sphinx-build leftovers
rm -rf html/.{doctrees,buildinfo}
%endif

%install
%pyproject_install

%if_with docs
# install man page
install -pDm 644 man/openstackclientclibase.1 %buildroot%_man1dir/openstackclientclibase.1
%endif

%check
%__python3 -m stestr run

%files
%doc LICENSE AUTHORS ChangeLog *.rst
%python3_sitelibdir/osc_lib
%python3_sitelibdir/osc_lib-%version.dist-info
%exclude %python3_sitelibdir/osc_lib/tests

%files tests
%python3_sitelibdir/osc_lib/tests

%if_with docs
%files doc
%doc LICENSE *.rst html
%_man1dir/openstackclientclibase.1.xz
%endif

%changelog
