%define oname oslo.service
%def_without check
%def_with docs

Name: python3-module-%oname
Version: 3.1.1
Release: alt0.p10

Summary: OpenStack Oslo Service library

License: Apache-2.0
Group: Development/Python3
Url: https://pypi.org/project/oslo.service

Source: %oname-%version.tar
Source1: %oname.watch

BuildArch: noarch

Provides: python3-module-oslo-service = %EVR

# Very strange thing, idk where it came from :)
%add_python3_req_skip __original_module_threading

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
BuildRequires: python3-module-webob >= 1.7.1
BuildRequires: python3-module-debtcollector >= 1.2.0
BuildRequires: python3-module-eventlet >= 0.25.2
BuildRequires: python3-module-fixtures >= 3.0.0
BuildRequires: python3-module-greenlet >= 0.4.15
BuildRequires: python3-module-oslo.utils >= 3.40.2
BuildRequires: python3-module-oslo.concurrency >= 3.25.0
BuildRequires: python3-module-oslo.config >= 5.1.0
BuildRequires: python3-module-oslo.log >= 3.36.0
BuildRequires: python3-module-oslo.i18n >= 3.15.3
BuildRequires: python3-module-PasteDeploy >= 1.5.0
BuildRequires: python3-module-routes >= 2.3.1
BuildRequires: python3-module-paste >= 2.0.2
BuildRequires: python3-module-yappi >= 1.0

%if_with check
BuildRequires: python3-module-hacking >= 3.0.1
BuildRequires: python3-module-oslotest >= 3.2.0
BuildRequires: python3-module-requests >= 2.14.2
BuildRequires: python3-module-stestr >= 2.0.0
BuildRequires: python3-module-doc8 >= 0.6.0
BuildRequires: python3-module-coverage >= 4.0
BuildRequires: python3-module-bandit >= 1.6.0
BuildRequires: /proc
BuildRequires: python3-module-pre-commit >= 2.6.0
%endif

%if_with docs
BuildRequires: python3-module-sphinx
BuildRequires: python3-module-openstackdocstheme >= 1.18.1
%endif

Requires: python3-module-webob >= 1.7.1
Requires: python3-module-debtcollector >= 1.2.0
Requires: python3-module-eventlet >= 0.25.2
Requires: python3-module-fixtures >= 3.0.0
Requires: python3-module-greenlet >= 0.4.15
Requires: python3-module-oslo.utils = 6.1.0
Requires: python3-module-oslo.concurrency >= 5.1.0 python3-module-oslo.concurrency <= 5.1.1
Requires: python3-module-oslo.config >= 9.1.0 python3-module-oslo.config <= 9.1.1
Requires: python3-module-oslo.log >= 5.1.0 python3-module-oslo.log <= 5.2.0
Requires: python3-module-oslo.i18n = 6.0.0
Requires: python3-module-PasteDeploy >= 1.5.0
Requires: python3-module-routes >= 2.3.1
Requires: python3-module-paste >= 2.0.2
Requires: python3-module-yappi >= 1.0

%description
This project provides a framework for defining new long-running services
using the patterns established by other OpenStack applications. It also includes
utilities long-running applications might need for working with SSL or WSGI,
performing periodic operations, interacting with systemd, etc.

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR

%description tests
This package contains tests for %oname.

%if_with docs
%package doc
Summary: Documentation for %oname
Group: Development/Documentation
Provides: python3-module-oslo-service-doc = %EVR

%description doc
This package contains documentation for %oname.
%endif

%prep
%setup -n %oname-%version

# Remove bundled egg-info
rm -rfv *.egg-info

%build
%pyproject_build

%if_with docs
export PYTHONPATH="$PWD"
# generate html docs
sphinx-build-3 doc/source html
# generate man page
sphinx-build-3 -b man doc/source man
# remove the sphinx-build leftovers
rm -rf html/.{doctrees,buildinfo}
%endif

%install
%pyproject_install

%if_with docs
# install man page
install -pDm 644 man/osloservice.1 %buildroot%_man1dir/osloservice.1
%endif

%check
%__python3 -m stestr run

%files
%doc LICENSE AUTHORS ChangeLog *.rst
%python3_sitelibdir/oslo_service
%python3_sitelibdir/%oname-%version.dist-info
%exclude %python3_sitelibdir/oslo_service/tests

%files tests
%python3_sitelibdir/oslo_service/tests

%if_with docs
%files doc
%doc LICENSE *.rst html
%_man1dir/osloservice.1.xz
%endif

%changelog
