%define oname ovsdbapp
%def_with check
%def_with docs

Name: python3-module-%oname
Version: 2.2.1
Release: alt1.1.p10

Summary: OpenStack library for creating OVSDB applications

License: Apache-2.0
Group: Development/Python3
Url: https://pypi.org/project/ovsdbapp

Source: %oname-%version.tar
Source1: %oname.watch

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
BuildRequires: python3-module-fixtures >= 3.0.0
BuildRequires: python3-module-netaddr >= 0.7.18
BuildRequires: python3-module-openvswitch >= 2.10.0
BuildRequires: python3-module-pbr >= 2.0.0

%if_with check
BuildRequires: python3-module-coverage >= 4.0
BuildRequires: python3-module-isort = 4.3.21
BuildRequires: python3-module-subunit >= 1.0.0
BuildRequires: python3-module-oslotest >= 3.2.0
BuildRequires: python3-module-stestr >= 2.0.0
BuildRequires: python3-module-testscenarios >= 0.4
BuildRequires: python3-module-testtools >= 2.2.0
%endif

%if_with docs
BuildRequires: python3-module-sphinx >= 2.0.0
BuildRequires: python3-module-openstackdocstheme >= 2.2.1
BuildRequires: python3-module-reno >= 3.1.0
%endif

Requires: python3-module-fixtures >= 3.0.0
Requires: python3-module-netaddr >= 0.7.18
Requires: python3-module-openvswitch >= 2.10.0
Requires: python3-module-pbr >= 2.0.0

%description
A library for creating OVSDB applications

The ovdsbapp library is useful for creating applications that communicate
via Open_vSwitch's OVSDB protocol (https://tools.ietf.org/html/rfc7047). It
wraps the Python 'ovs' and adds an event loop and friendly transactions.

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR

%description tests
This package contains tests for %oname.

%if_with docs
%package doc
Summary: Documentation for %oname
Group: Development/Documentation

%description doc
This package contains documentation for %oname.
%endif

%prep
%setup -n %oname-%version

# Remove bundled egg-info
rm -rfv *.egg-info

%build
%pyproject_build

%if_with docs
export PYTHONPATH="$PWD"
# generate html docs
sphinx-build-3 doc/source html
# generate man page
sphinx-build-3 -b man doc/source man
# remove the sphinx-build leftovers
rm -rf html/.{doctrees,buildinfo}
%endif

%install
%pyproject_install

%if_with docs
# install man page
install -pDm 644 man/%oname.1 %buildroot%_man1dir/%oname.1
%endif

%check
export OS_TEST_PATH=ovsdbapp/tests/unit
%__python3 -m stestr run

%files
%doc LICENSE AUTHORS ChangeLog *.rst
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version.dist-info
%exclude %python3_sitelibdir/%oname/tests

%files tests
%python3_sitelibdir/%oname/tests

%if_with docs
%files doc
%doc LICENSE *.rst html
%_man1dir/%oname.1.xz
%endif

%changelog
