%define _unpackaged_files_terminate_build 1
%define pypi_name paramiko

%def_with check

Name: python3-module-%pypi_name
Version: 2.11.0
Release: alt1

Summary: SSH2 protocol for python
License: LGPL-2.1
Group: Development/Python3
# Source-git: https://github.com/paramiko/paramiko.git
Url: http://www.paramiko.org/

Source: %name-%version.tar
Patch: %name-%version-alt.patch

BuildRequires(pre): rpm-build-python3

# build backend and its deps
BuildRequires: python3(setuptools)
BuildRequires: python3(wheel)

%if_with check
# deps
BuildRequires: python3(six)
BuildRequires: python3(bcrypt)
BuildRequires: python3(cryptography)
BuildRequires: python3(nacl)

# extras
BuildRequires: python3(gssapi)
BuildRequires: python3(pyasn1)
BuildRequires: python3(invoke)

BuildRequires: python3(k5test)
BuildRequires: python3(mock)
%endif

BuildArch: noarch

%description
paramiko is a module for python that implements the SSH2 protocol for secure
(encrypted and authenticated) connections to remote machines. It is written
entirely in python (no C or platform-dependent code).

%prep
%setup
%patch -p1

%build
%pyproject_build

%install
%pyproject_install

%check
%tox_create_default_config
%tox_check_pyproject

%files
%doc README.rst LICENSE
%python3_sitelibdir/paramiko/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
