%define oname passlib

# very slow:
%def_disable check

Name:		python3-module-%oname
Version:	1.7.4
Release:	alt1

Summary:	Comprehensive password hashing framework supporting over 20 schemes

License:	BSD and Beerware and Copyright only
Group:		Development/Python3
URL:		https://foss.heptapod.net/python-libs/passlib/-/wikis/home

# Source-url: %__pypi_url %oname
Source:	%name-%version.tar

BuildArch:	noarch

BuildRequires(pre): rpm-build-intro >= 2.2.4
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-setuptools

%if_enabled check
BuildRequires: python3-module-nose
%endif

BuildRequires(pre): rpm-macros-sphinx3
BuildRequires: python3-module-sphinx

%description
Passlib is a password hashing library for Python 2 & 3, which provides
cross-platform implementations of over 20 password hashing algorithms,
as well as a framework for managing existing password hashes. It's
designed to be useful for a wide range of tasks, from verifying a hash
found in /etc/shadow, to providing full-strength password hashing for
multi-user application.

%package docs
Summary: Documentation for %oname
Group: Development/Documentation

%description docs
Passlib is a password hashing library for Python 2 & 3, which provides
cross-platform implementations of over 20 password hashing algorithms,
as well as a framework for managing existing password hashes. It's
designed to be useful for a wide range of tasks, from verifying a hash
found in /etc/shadow, to providing full-strength password hashing for
multi-user application.

This package contains documentation for %oname.

%prep
%setup

%prepare_sphinx3 .
ln -s ../objects.inv docs/
sed -i 's|@VERSION@|%version|' docs/conf.py

%build
%python3_build_debug

%install
%python3_install
%python3_prune

%if 0
export PYTHONPATH=$PWD
pushd docs
sphinx-build -b html -d build/doctrees . build/html
popd
%endif

%check
python3 setup.py test

%files
%doc LICENSE README
%python3_sitelibdir/*

%changelog
