%define pypi_name pbr

%def_without doc

%define descr \
PBR is a library that injects some useful and sensible default behaviors \
into your setuptools run. It started off life as the chunks of code that \
were copied between all of the OpenStack projects. Around the time that \
OpenStack hit 18 different projects each with at least 3 active \
branches, it seems like a good time to make that code into a proper \
re-usable library.

Name:       python3-module-%pypi_name
Version:    6.0.0
Release:    alt1

Summary:    Python Build Reasonableness

Group:      Development/Python3
License:    Apache-2.0
URL:        http://pypi.python.org/pypi/pbr

# Source-url: %__pypi_url %pypi_name
Source: %name-%version.tar

BuildRequires(pre): rpm-build-intro >= 2.2.4
BuildRequires(pre): rpm-build-python3

%if_with doc
BuildRequires: python3-module-sphinx python3-module-sphinxcontrib-apidoc
%endif

BuildArch:  noarch

Conflicts: python-module-pbr < 5.5.0-alt4

# for python w/o distutils
%filter_from_requires /python3(distutils.*)/d
Requires: python3(setuptools._distutils)

%description
%descr

%prep
%setup
# Remove the requirements file so that pbr hooks don't add it
# to distutils requiers_dist config
rm -rf {test-,}requirements.txt

# Remove bundled egg-info
rm -rf %{pypi_name}.egg-info

%build
export PBR_VERSION="%version"
export SKIP_PIP_INSTALL=1
%python3_build

%if_with doc
# generate html docs
sphinx-build-3 doc/source html
# remove the sphinx-build leftovers
rm -rf html/.{doctrees,buildinfo}
%endif

%install
export PBR_VERSION="%version"
%python3_install
%python3_prune

# no idea who use it
rm -fv %buildroot%python3_sitelibdir/%pypi_name/sphinxext.py

%files
%doc README.rst LICENSE
%if_with doc
%doc html
%endif
%_bindir/*
%python3_sitelibdir/%pypi_name-%version-py*.egg-info
%python3_sitelibdir/%pypi_name

%changelog
