%define _unpackaged_files_terminate_build 1

%define oname pydocstyle

Name: python3-module-%oname
Version: 6.1.1
Release: alt1
Summary: Python docstring style checker
License: MIT
Group: Development/Python3
BuildArch: noarch
Url: https://pypi.python.org/pypi/pydocstyle

# https://github.com/PyCQA/pydocstyle.git
Source: %name-%version.tar
Patch1: %oname-%version-alt-docs.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-html5lib python3-module-mock python3-module-pytest
BuildRequires: python3(configparser) python3(snowballstemmer) python3(six)
# Documentation
BuildRequires(pre): rpm-macros-sphinx3
BuildRequires: python3-module-alabaster python3-module-objects.inv python3-module-sphinx python3-module-sphinx-sphinx-build-symlink

# Conflicts due to binaries in /usr/bin
Conflicts: python-module-%oname

%description
pydocstyle is a static analysis tool for checking
compliance with Python docstring conventions.

pydocstyle supports most of PEP 257 out of the box,
but it should not be considered a reference implementation.

%package pickles
Summary: Pickles for %oname
Group: Development/Python3

%description pickles
pydocstyle is a static analysis tool for checking
compliance with Python docstring conventions.

pydocstyle supports most of PEP 257 out of the box,
but it should not be considered a reference implementation.

This package contains pickles for %oname.

%package docs
Summary: Documentation for %oname
Group: Development/Documentation
BuildArch: noarch

%description docs
pydocstyle is a static analysis tool for checking
compliance with Python docstring conventions.

pydocstyle supports most of PEP 257 out of the box,
but it should not be considered a reference implementation.

This package contains documentation for %oname.

%prep
%setup
%patch1 -p1

%prepare_sphinx3 .
ln -s ../objects.inv docs/

%build
%python3_build_debug

%install
%python3_install

%make -C docs pickle
%make -C docs html

install -d %buildroot%python3_sitelibdir/%oname
cp -fR docs/_build/pickle %buildroot%python3_sitelibdir/%oname/

%check
export LC_ALL=en_US.UTF-8
# those tests are known to fail
rm -f src/tests/test_integration.py
PYTHONPATH=%buildroot%python3_sitelibdir py.test3 -vv

%files
%doc LICENSE-MIT
%doc README.rst
%_bindir/*
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*/pickle

%files pickles
%python3_sitelibdir/*/pickle

%files docs
%doc docs/_build/html/*

%changelog
