%define _unpackaged_files_terminate_build 1
%define oname pyflakes

%def_with check

Name: python3-module-%oname
Version: 2.3.1
Release: alt1

Summary: A simple program which checks Python source files for errors
License: MIT
Group: Development/Python3
Url: https://pypi.python.org/pypi/pyflakes
BuildArch: noarch

# https://github.com/PyCQA/pyflakes.git
Source: %name-%version.tar
Source1: pyflakes.1
Patch0: %name-%version-alt.patch

BuildRequires(pre): rpm-build-python3

%if_with check
BuildRequires: python3(tox)
%endif

Provides: python3-pyflakes = %EVR
Obsoletes: python3-pyflakes < %EVR


%description
Pyflakes is similar to PyChecker in scope, but differs in that it does\
not execute the modules to check them. This is both safer and faster,\
although it does not perform as many checks. Unlike PyLint, Pyflakes\
checks only for logical errors in programs; it does not perform any\
check on style.

%prep
%setup
%autopatch -p1

%build
%python3_build

%install
%python3_install

install -Dpm 644 %SOURCE1 %buildroot%_man1dir/python3-pyflakes.1

mv %buildroot%_bindir/{pyflakes,pyflakes-py3}

# don't package tests
rm -r %buildroot%python3_sitelibdir/pyflakes/test

%check
export PIP_NO_INDEX=YES
export TOXENV=py3
tox.py3 --sitepackages -vvr

%files
%doc AUTHORS LICENSE README.rst
%_man1dir/python3-pyflakes.1*
%_bindir/pyflakes-py3
%python3_sitelibdir/pyflakes/
%python3_sitelibdir/pyflakes-*.egg-info/


%changelog
