%define oname pyglet

%def_disable docs

Name: python3-module-%oname
Version: 1.3.0
Release: alt5.a1.hg20150730
Summary: Cross-platform windowing and multimedia library

Group: Development/Python3
License: BSD
URL: http://www.pyglet.org/
# hg clone https://bitbucket.org/pyglet/pyglet
Source: %oname-%version.tar.gz
BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-macros-sphinx3
BuildRequires: python3-module-html5lib python3-module-sphinx

%add_python3_req_skip Cocoa CoreFoundation LaunchServices Quartz
%filter_from_requires /darwin/d
%filter_from_requires /carbon/d
%filter_from_requires /win32/d

%description
pyglet provides an object-oriented programming interface for developing
games and other visually-rich applications for Windows, Mac OS X and
Linux.

%if_enabled docs

%package pickles
Summary: Pickles for cross-platform windowing and multimedia library
Group: Development/Python

%description pickles
pyglet provides an object-oriented programming interface for developing
games and other visually-rich applications for Windows, Mac OS X and
Linux.

This package contains pickles for pyglet.

%package docs
Summary: Documentation for cross-platform windowing and multimedia library
Group: Development/Documentation
BuildArch: noarch

%description docs
pyglet provides an object-oriented programming interface for developing
games and other visually-rich applications for Windows, Mac OS X and
Linux.

This package contains development documentation for pyglet.

%endif

%prep
%setup

touch tools/__init__.py

%if_enabled docs
%prepare_sphinx .
%endif

%build
%python3_build

%install
%python3_install
pushd %buildroot%python3_sitelibdir/%oname
rm -fR */win32* libs/darwin input/*win* */*carbon.* \
	image/codecs/quicktime.* image/codecs/gdiplus.*
popd

%if_enabled docs
./make.py clean
mkdir -p doc/_build/html
./make.py docs

#generate_pickles $PWD $PWD/doc/_build/html %oname
%make -C doc pickle
install -d %buildroot%python_sitelibdir/%oname
cp -fR doc/_build/pickle %buildroot%python_sitelibdir/%oname/
%endif

%files
%doc CHANGELOG DESIGN LICENSE NOTICE PY3K README
%python3_sitelibdir/*
%if_enabled docs
%exclude %python3_sitelibdir/%oname/pickle
%endif

%if_enabled docs
%files pickles
%dir %python3_sitelibdir/%oname
%python3_sitelibdir/%oname/pickle

%files docs
%doc doc/programming_guide doc/_build/html examples
%endif

%changelog
