%def_disable snapshot

%define _name pygobject
%define ver_major 3.40
%define api_ver 3.0
%define gtk_api_ver 3.0
%def_enable pycairo
%def_disable devel_doc
%def_enable tests
%def_disable check

Name: python3-module-%{_name}3
Version: %ver_major.1
Release: alt2.p10.2

Summary: Python3 bindings for GObject
Group: Development/Python
License: LGPL-2.1
Url: http://www.pygtk.org/

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version.tar.xz
%else
Source: %_name-%version.tar
%endif
Patch: pygobject-3.38.0-alt-meson-0.55_build.patch

%add_findprov_lib_path %python3_sitelibdir/gi

%add_typelib_req_skiplist typelib(Foo)
%filter_from_requires /Gst.*/d
%filter_from_requires /typelib(WebKit)/d
# gi/_gtktemplate.py -> overrides/Gtk.py
%filter_from_requires /typelib(Gtk)/d
%filter_from_requires /typelib(GdkX11)/d

%define glib_ver 2.56.0
%define gi_ver 1.56.0
%define pycairo_ver 1.16

Requires: %name-nox = %EVR
# required by /gi/overrides/Gdk.py
Requires: typelib(cairo)

BuildRequires(pre): meson rpm-build-gir rpm-build-python3
BuildRequires: gtk-doc
BuildRequires: glib2-devel >= %glib_ver libgio-devel libffi-devel
BuildRequires: gobject-introspection-devel >= %gi_ver
BuildRequires: python3-devel python3-module-pytest 
%{?_enable_pycairo:BuildRequires: python3-module-pycairo-devel libcairo-gobject-devel}
%{?_enable_check:BuildRequires: xvfb-run dbus-tools-gui libgtk+3-gir-devel glibc-i18ndata}

%description
GObject is a object system used by GTK+, GStreamer and other libraries.

PyGObject provides a convenient wrapper for use in Python programs when
accessing GObject libraries.

PyGObject now dynamically accesses any GObject libraries that uses
GObject Introspection. It replaces the need for separate modules such as
PyGTK, GIO and python-gnome to build a full GNOME 3.0 application. Once
new functionality is added to gobject library it is instantly available
as a Python API without the need for intermediate Python glue.

%package nox
Summary: PyGObject w/o Cairo dependencies
Group: Development/Python3
#Requires: %name = %EVR
%filter_from_requires /typelib(cairo)/d

%description nox
This package provides a part of PyGObject without Cairo dependencies.

%package pygtkcompat
Summary: PyGTK compatibility layer for PyGObject
Group: Development/Python3
Requires: %name = %EVR

%description pygtkcompat
PyGTK compatibility layer.
It is recommended to not depend on this layer, but only use it as an
intermediate step when porting your application to PyGI. Compatibility
might never be 100%%, but the aim is to make it possible to run a well
behaved PyGTK application mostly unmodified on top of PyGI.

%package devel
Summary: Development files for %name
Group: Development/Python3
Requires: %name = %EVR
Obsoletes: python-module-pygobject3-common-devel < 3.37
Provides: python-module-pygobject3-common-devel = %EVR

%description devel
Development files for %name.

%package devel-doc
Summary: Development documentation for %_name
Group: Development/Documentation
BuildArch: noarch
Conflicts: %name-common-devel < %version-%release

%description devel-doc
Development documentation for %_name.

%prep
%setup -n %_name-%version
%patch -p1

%build
%meson \
	%{?_disable_pycairo:-Dpycairo=disabled} \
	%{?_disable_tests:-Dtests=false}
%nil
%meson_build

%install
%meson_install

%check
xvfb-run %meson_test

%files
%{?_enable_pycairo:%python3_sitelibdir/gi/_gi_cairo.cpython-*.so}

%files nox
%dir %python3_sitelibdir/gi/
%python3_sitelibdir/gi/overrides/
%python3_sitelibdir/gi/repository/
%python3_sitelibdir/gi/*.py
%python3_sitelibdir/gi/_gi.cpython-*.so
%{?_enable_pycairo:%exclude %python3_sitelibdir/gi/_gi_cairo.cpython-*.so}
%python3_sitelibdir/gi/__pycache__/
%python3_sitelibdir/*.egg-info
%exclude %python3_sitelibdir/gi/pygtkcompat.py*

%files pygtkcompat
%python3_sitelibdir/pygtkcompat/
%python3_sitelibdir/gi/pygtkcompat.py*

%files devel
%_includedir/%_name-%api_ver/
%_pkgconfigdir/%_name-%api_ver.pc
%doc README* NEWS examples

%if_enabled devel_doc
%files devel-doc
%_datadir/gtk-doc/html/%_name/
%endif

%changelog
