%define oname pyod

Name: python3-module-pyod
Version: 0.8.6
Release: alt1

Summary: A Python Toolbox for Scalable Outlier Detection (Anomaly Detection)

Group: Development/Python3
License: MIT
Url: https://github.com/yzhao062/pyod

# Source-url: https://github.com/yzhao062/pyod/archive/V%version.tar.gz
Source: %name-%version.tar

BuildArch: noarch

BuildRequires(pre): rpm-build-python3 rpm-build-intro

# generated by 'epm restore --dry-run' from pyod/requirements.txt
%py3_use combo
%py3_use joblib
#py3_use matplotlib
%py3_use numpy >= 1.13
%py3_use numba >= 0.35
#py3_use pandas >= 0.25
%py3_use scipy >= 0.19.1
%py3_use scikit-learn >= 0.19.1
%py3_use six
%py3_use scikits.statsmodels
#py3_use statsmodels

# generated by 'epm restore --dry-run' from pyod/setup.py setup_requires
%py3_buildrequires setuptools >= 38.6.0

#**Optional Dependencies (see details below)**\ :
#* keras (optional, required for AutoEncoder)
#* matplotlib (optional, required for running examples)
#* pandas (optional, required for running benchmark)
#* tensorflow (optional, required for AutoEncoder, other backend works)
#* xgboost (optional, required for XGBOD)
%add_python3_req_skip tensorflow xgboost.sklearn

# for tests
BuildRequires: python3-module-pytest python3-module-scikit-learn python3-module-numba

%description
PyOD is a comprehensive and scalable Python toolkit for detecting outlying objects in multivariate data.
This exciting yet challenging field is commonly referred as Outlier Detection or Anomaly Detection.

PyOD includes more than 30 detection algorithms, from classical LOF (SIGMOD 2000) to the latest COPOD (ICDM 2020).

%prep
%setup

%build
%python3_build_debug

%install
%python3_install
%python3_prune
rm -rfv %buildroot/%python3_sitelibdir/examples/

%check
PYTHONPATH=$(pwd) py.test3 || echo "Test result are ignored. Wait for https://bugzilla.altlinux.org/show_bug.cgi?id=39744"

%files
%python3_sitelibdir/%oname/
%python3_sitelibdir/%oname-*.egg-info/

%changelog
