%define oname pyparsing

%def_without check

Name: python3-module-pyparsing
Version: 2.4.7
Release: alt1

Summary: Python parsing module

License: MIT
Group: Development/Python3
URL: https://pypi.org/project/pyparsing

# Source-url: %__pypi_url %oname
Source: %name-%version.tar

BuildArch: noarch

BuildRequires(pre): rpm-build-intro >= 2.2.5
BuildRequires(pre): rpm-build-python3

%if_with check
BuildRequires: python3(coverage)
BuildRequires: python3(tox)
%endif


%description
The parsing module is an alternative approach to creating and executing
simple grammars, vs. the traditional lex/yacc approach, or the use of
regular expressions.  The parsing module provides a library of classes
that client code uses to construct the grammar directly in Python code.

%prep
%setup

%build
%python3_build

%install
%python3_install
%python3_prune

%check
sed -i '/^\[testenv\]$/a whitelist_externals =\
    \/bin\/cp\
    \/bin\/sed\
setenv =\
    py%{python_version_nodots python3}: _COV_BIN=%_bindir\/coverage3\
commands_pre =\
    \/bin\/cp {env:_COV_BIN:} \{envbindir\}\/coverage\
    \/bin\/sed -i \x271c #!\{envpython\}\x27 \{envbindir\}\/coverage' tox.ini
export PIP_NO_INDEX=YES
export TOXENV=py%{python_version_nodots python3}
tox.py3 --sitepackages -p auto -o -v

%files
%doc CHANGES README.rst
%python3_sitelibdir/%oname-%version-py%_python3_version.egg-info/
%python3_sitelibdir/%oname.py
%python3_sitelibdir/__pycache__/%oname.cpython-*.py*

%changelog
