%define rname pyscard

Name:       python3-module-%rname
Version:    1.9.9
Release:    alt2

Summary:    A framework for building smart card aware applications in Python
License:    LGPLv2+ and Python and CC-BY-SA
Group:      Development/Python3
URL:        https://sourceforge.net/projects/pyscard/
Packager:   Andrey Cherepanov <cas@altlinux.org>

Source0:    %rname-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires:  python3-module-Pyro4
BuildRequires:  libpcsclite-devel
BuildRequires:  swig >= 1.3.31

Requires:   pcsc-lite
Provides:   pyscard = %version-%release


%description
The pyscard smartcard library is a framework for building smart card
aware applications in Python. The smartcard module is built on top of
the PCSC API Python wrapper module.

%prep
%setup -q -n %rname-%version

# license file is CRLF terminated -- prevent a rpmlint warning
subst 's/\r//' LICENSE
# Adapt to use Pyro4
subst 's/Pyro\./Pyro4./g' smartcard/pyro/PyroReader.py

# fix import of bsddb
sed -i 's|_bsddb|bsddb3._pybsddb|' smartcard/CardNames.py
sed -i 's|from bsddb import|from bsddb3 import|' smartcard/CardNames.py

%build
%python3_build

%install
%python3_install
# chmod 755 %buildroot%python3_sitelibdir/smartcard/scard/_scard.so

%files
%doc README.md LICENSE
%doc smartcard/doc/*
%doc smartcard/Examples
%python3_sitelibdir/*


%changelog
