%define _unpackaged_files_terminate_build 1
%define oname pytest

%def_with check

Name: python3-module-%oname
Version: 7.0.1
Release: alt2

Summary: Python test framework
License: MIT
Group: Development/Python3
# Source-git: https://github.com/pytest-dev/pytest.git
Url: https://pypi.org/project/pytest/

Source: %name-%version.tar
Patch: %name-%version-alt.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3(setuptools_scm)

%if_with check
# install_requires:
BuildRequires: python3(attr)
BuildRequires: python3(iniconfig)
BuildRequires: python3(packaging)
BuildRequires: python3(pluggy)
BuildRequires: python3(py)
BuildRequires: python3(tomli)

# extras_require:
BuildRequires: python3(argcomplete)
BuildRequires: python3(hypothesis)
BuildRequires: python3(mock)
BuildRequires: python3(nose)
BuildRequires: python3(requests)
BuildRequires: python3(xmlschema)
BuildRequires: python3-module-Pygments > 2.4.2

BuildRequires: /dev/pts
BuildRequires: /dev/shm

BuildRequires: python3(tox)

# optional
BuildRequires: python3(decorator)
BuildRequires: python3(jinja2)
BuildRequires: python3(numpy)
BuildRequires: python3(pexpect)
%endif

BuildArch: noarch

%py3_requires py
%py3_requires tomli
%py3_requires packaging

%description
The pytest framework makes it easy to write small tests, yet
scales to support complex functional testing for applications and libraries.

%package -n pytest3
Summary: Additional executable for pytest
Group: Development/Python3
Requires: python3-module-%oname = %EVR
# It simply has executables with the same filename:
Conflicts: python3-module-logilab-common < 1.0.2-alt2.hg20150708

%description -n pytest3
The pytest framework makes it easy to write small tests, yet
scales to support complex functional testing for applications and libraries.

%prep
%setup
%patch -p1

%build
# SETUPTOOLS_SCM_PRETEND_VERSION: when defined and not empty,
# its used as the primary source for the version number in which
# case it will be a unparsed string
export SETUPTOOLS_SCM_PRETEND_VERSION=%version

%python3_build

%install
export SETUPTOOLS_SCM_PRETEND_VERSION=%version

%python3_install
mv %buildroot%_bindir/py.test -T %buildroot%_bindir/py.test3
mv %buildroot%_bindir/pytest -T %buildroot%_bindir/pytest3
ln -s py.test3 %buildroot%_bindir/py.test-3
ln -s pytest3 %buildroot%_bindir/pytest-3

%check
# add workaround for https://github.com/pytest-dev/pytest/issues/6297
export TERM=xterm
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
export PIP_NO_BUILD_ISOLATION=no
export PIP_NO_INDEX=YES
export TOXENV=py3
tox.py3 --sitepackages -vvr -s false -- -vra

%files
%doc AUTHORS LICENSE *.rst
%_bindir/py.test3
%_bindir/py.test-3
%python3_sitelibdir/pytest/
%python3_sitelibdir/_pytest/
%python3_sitelibdir/%oname-%version-py%_python3_version.egg-info/

%files -n pytest3
%_bindir/pytest3
%_bindir/pytest-3

%changelog
