%define _unpackaged_files_terminate_build 1
%define pypi_name pytest-bdd

%def_with check

Name: python3-module-%pypi_name
Version: 6.0.1
Release: alt1

Summary: BDD library for the py.test runner
License: MIT
Group: Development/Python3
Url: https://pypi.org/project/pytest-bdd/
# https://github.com/pytest-dev/pytest-bdd.git
BuildArch: noarch

Source: %name-%version.tar
Patch0: %name-%version-alt.patch

BuildRequires(pre): rpm-build-python3

# build backend and its deps
BuildRequires: python3(setuptools)
BuildRequires: python3(wheel)

%if_with check
BuildRequires: python3(execnet)
BuildRequires: python3(glob2)
BuildRequires: python3(mako)
BuildRequires: python3(parse)
BuildRequires: python3(parse_type)
%endif

%py3_provides %pypi_name

%description
pytest-bdd implements a subset of Gherkin language for the automation of
the project requirements testing and easier behavioral driven
development.

Unlike many other BDD tools it doesn't require a separate runner and
benefits from the power and flexibility of the pytest. It allows to
unify your unit and functional tests, easier continuous integration
server configuration and maximal reuse of the tests setup.

Pytest fixtures written for the unit tests can be reused for the setup
and actions mentioned in the feature steps with dependency injection,
which allows a true BDD just-enough specification of the requirements
without maintaining any context object containing the side effects of
the Gherkin imperative declarations.

%prep
%setup
%autopatch -p1

%build
%pyproject_build

%install
%pyproject_install

%check
%tox_check_pyproject

%files
%doc CHANGES.rst README.rst
%_bindir/pytest-bdd
%python3_sitelibdir/pytest_bdd/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
