%define _unpackaged_files_terminate_build 1
%define oname pytest-benchmark

%def_with check

Name: python3-module-%oname
Version: 3.4.1
Release: alt2
Summary: pytest fixture for benchmarking code
License: BSD-2-Clause
Group: Development/Python3
BuildArch: noarch
Url: https://pypi.org/project/pytest-benchmark/

# https://github.com/ionelmc/pytest-benchmark.git
Source: %name-%version.tar
Patch: %name-%version-alt.patch

BuildRequires(pre): rpm-build-python3

%if_with check
# install_requires=
BuildRequires: python3(pytest)
BuildRequires: python3(cpuinfo)

BuildRequires: python3(tox)
BuildRequires: python3(tox_console_scripts)
BuildRequires: python3(tox_no_deps)

BuildRequires: python3(aspectlib)
BuildRequires: python3(elasticsearch)
BuildRequires: python3(freezegun)
BuildRequires: python3(pygal)
BuildRequires: /usr/bin/git
%endif

%py3_requires cpuinfo

# PEP503 name
%py3_provides %oname

%description
A pytest fixture for benchmarking code.

%prep
%setup
%patch -p1

%build
%python3_build

%install
%python3_install
pushd %buildroot%_bindir
for i in $(ls); do
	mv $i ${i}.py3
done

%check
export PIP_NO_INDEX=YES
export TOXENV=py%{python_version_nodots python3}-nocov
tox.py3 --sitepackages --console-scripts --no-deps -vvr

%files
%doc README.rst CHANGELOG.rst
%_bindir/py.test-benchmark.py3
%_bindir/pytest-benchmark.py3
%python3_sitelibdir/pytest_benchmark/
%python3_sitelibdir/pytest_benchmark-%version-py%_python3_version.egg-info/

%changelog
