%define _unpackaged_files_terminate_build 1
%define oname pytest-mock

%def_with check

Name: python3-module-%oname
Version: 3.5.1
Release: alt1

Summary: Thin-wrapper around the mock package for easier use with py.test
License: MIT
Group: Development/Python3
# https://github.com/pytest-dev/pytest-mock.git
Url: https://pypi.python.org/pypi/pytest-mock

Source: %name-%version.tar
Patch: %name-%version-alt.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3(setuptools_scm)

%if_with check
BuildRequires: python3(pytest-asyncio)
BuildRequires: python3(tox)
%endif

%py3_provides %oname

BuildArch: noarch
%description
Thin-wrapper around the mock package for easier use with py.test

This plugin installs a mocker fixture which is a thin-wrapper around the
patching API provided by the mock package, but with the benefit of not having
to worry about undoing patches at the end of a test

%prep
%setup
%patch -p1

%build
# SETUPTOOLS_SCM_PRETEND_VERSION: when defined and not empty,
# its used as the primary source for the version number in which
# case it will be a unparsed string
export SETUPTOOLS_SCM_PRETEND_VERSION=%version

%python3_build

%install
export SETUPTOOLS_SCM_PRETEND_VERSION=%version

%python3_install

%check
export PIP_NO_INDEX=YES
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
export TOXENV=py3
tox.py3 --sitepackages -vvr

%files
%doc LICENSE *.rst
%python3_sitelibdir/pytest_mock/
%python3_sitelibdir/pytest_mock-*.egg-info/

%changelog
