%define _unpackaged_files_terminate_build 1
%define oname pytest-randomly

%def_with check

Name: python3-module-%oname
Version: 3.7.0
Release: alt1

Summary: Pytest plugin to randomly order tests and control random.seed
License: MIT
Group: Development/Python
# Source-git: https://github.com/pytest-dev/pytest-randomly
Url: https://pypi.org/project/pytest-randomly/

Source: %name-%version.tar
Patch: %name-%version-alt.patch

BuildRequires(pre): rpm-build-python3

%if_with check
BuildRequires: python3(appdirs)
BuildRequires: python3(entrypoints)
BuildRequires: python3(factory)
BuildRequires: python3(faker)
BuildRequires: python3(numpy)
BuildRequires: python3(pytest)
BuildRequires: python3(pytest_xdist)
BuildRequires: python3(tox)
BuildRequires: python3(tox_console_scripts)
%endif

BuildArch: noarch

# PyPi name
%py3_provides pytest-randomly

%description
Randomness in testing can be quite powerful to discover hidden flaws in the
tests themselves, as well as giving a little more coverage to your system.

By randomly ordering the tests, the risk of surprising inter-test dependencies
is reduced - a technique used in many places.

By resetting the random seed to a repeatable number for each test, tests can
create data based on random numbers and yet remain repeatable, for example
factory boy's fuzzy values. This is good for ensuring that tests specify the
data they need and that the tested system is not affected by any data that is
filled in randomly due to not being specified.

%prep
%setup
%patch -p1

%build
%python3_build

%install
%python3_install

%check
export PIP_NO_BUILD_ISOLATION=no
export PIP_NO_INDEX=YES
export TOXENV=py3
tox.py3 --sitepackages --console-scripts -vvr -- -vra

%files
%doc README.rst
%python3_sitelibdir/pytest_randomly.py
%python3_sitelibdir/__pycache__/pytest_randomly.*.py*
%python3_sitelibdir/pytest_randomly-*.egg-info/

%changelog
