%define _unpackaged_files_terminate_build 1
%define oname pytest-tornado

%def_with check

Name: python3-module-%oname
Version: 0.8.1
Release: alt1

Summary: Fixtures and markers to simplify testing of asynchronous tornado applications
License: Apache-2.0
Group: Development/Python3
BuildArch: noarch
Url: https://pypi.org/project/pytest-tornado/

# https://github.com/eugeniy/pytest-tornado.git
Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3

%if_with check
BuildRequires: python3(pytest)
BuildRequires: python3(tornado)
BuildRequires: python3(tox)
%endif

%py3_provides %oname


%description
A py.test plugin providing fixtures and markers to simplify testing of
asynchronous tornado applications.

%prep
%setup

%build
%python3_build_debug

%install
%python3_install

%check
cat > tox.ini <<EOF
[testenv]
commands =
    python test/create_cert.py --cert test/testcert.pem
    {envpython} -m pytest {posargs:-vra}
EOF
export PIP_NO_INDEX=YES
export TOXENV=py3
tox.py3 --sitepackages -vvr

%files
%doc README.rst
%python3_sitelibdir/pytest_tornado/
%python3_sitelibdir/*.egg-info/


%changelog
