%define oname pyuv

Name: python3-module-%oname
Version: 1.4.0
Release: alt2
Summary: Python interface for libuv
License: MIT
Group: Development/Python3
Url: https://pypi.python.org/pypi/pyuv/

# https://github.com/saghul/pyuv.git
# branch: v1.x
Source: %name-%version.tar

BuildRequires(pre): /dev/pts /proc
BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-macros-sphinx3
BuildRequires: python3-module-sphinx

%py3_provides %oname

%description
pyuv is a Python module which provides an interface to libuv. libuv is a
high performance asynchronous networking and platform abstraction
library.

%package pickles
Summary: Pickles for %oname
Group: Development/Python3

%description pickles
pyuv is a Python module which provides an interface to libuv. libuv is a
high performance asynchronous networking and platform abstraction
library.

This package contains pickles for %oname.

%package docs
Summary: Documentation for %oname
Group: Development/Documentation
BuildArch: noarch

%description docs
pyuv is a Python module which provides an interface to libuv. libuv is a
high performance asynchronous networking and platform abstraction
library.

This package contains documentation for %oname.

%prep
%setup

%prepare_sphinx3 .
ln -s ../objects.inv docs/

%build
%add_optflags -fno-strict-aliasing
%python3_build_debug

%install
%python3_install

%make SPHINXBUILD="sphinx-build-3" -C docs pickle
%make SPHINXBUILD="sphinx-build-3" -C docs html

cp -fR docs/_build/pickle %buildroot%python3_sitelibdir/%oname/

%check
python3 setup.py test

%files
%doc AUTHORS ChangeLog *.rst TODO examples
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*/pickle

%files pickles
%python3_sitelibdir/*/pickle

%files docs
%doc docs/_build/html/*

%changelog
