%define oname radssh

Name: python3-module-%oname
Version: 1.1.1
Release: alt2

Summary: RadSSH Module
License: BSD
Group: Development/Python3
BuildArch: noarch
Url: https://pypi.python.org/pypi/radssh/

# https://github.com/radssh/radssh.git
Source: %name-%version.tar
Patch1: %oname-%version-alt-docs.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-paramiko python3-module-netaddr
BuildRequires: python3-module-sphinx

%py3_provides %oname
%py3_requires paramiko netaddr
%add_python3_req_skip genders


%description
High level Paramiko-based toolkit, with an extensible parallel cluster
"shell".

%package pickles
Summary: Pickles for %oname
Group: Development/Python3

%description pickles
High level Paramiko-based toolkit, with an extensible parallel cluster
"shell".

This package contains pickles for %oname.

%package docs
Summary: Documentation for %oname
Group: Development/Documentation
BuildArch: noarch

%description docs
High level Paramiko-based toolkit, with an extensible parallel cluster
"shell".

This package contains documentation for %oname.

%prep
%setup
%patch1 -p1

sed -i 's|sphinx-build|sphinx-build-3|' docs/Makefile

sed -i 's|#!/usr/bin/env python|#!/usr/bin/env python3|' \
    $(find ./ -name '*.py')

%build
%python3_build_debug

%install
%python3_install

export PYTHONPATH=$PWD
%make -C docs pickle
%make -C docs html

cp -fR docs/build/pickle %buildroot%python3_sitelibdir/%oname/

%check
PYTHONPATH=%buildroot%python3_sitelibdir python3 tests/dispatcher.py

%files
%doc README *.md api_sample
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*/pickle

%files pickles
%python3_sitelibdir/*/pickle

%files docs
%doc docs/build/html/*


%changelog
