%define _unpackaged_files_terminate_build 1

%define mname scikits
%define rname statsmodels
%define oname %mname.%rname

%def_disable check

Name: python3-module-%oname
Epoch: 1
Version: 0.11.1
Release: alt2.1
Summary: Statistical computations and models for use with SciPy
License: BSD-3-Clause
Group: Development/Python3
Url: https://pypi.org/project/statsmodels/

# https://github.com/statsmodels/statsmodels.git
Source: %name-%version.tar

Patch1: %oname-alt-build.patch
Patch2: %oname-alt-check.patch
Patch3: %oname-alt-skipped-tests.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: libnumpy-py3-devel python3-devel
BuildRequires: python3-module-Cython
BuildRequires: python3-module-scipy

%if_enabled check
BuildRequires: python3-module-tox
BuildRequires: python3(patsy) python3(pandas) python3(pandas.util.testing)
BuildRequires: python3(joblib) python3(pytest-xdist)
%endif

%py3_provides %oname
%py3_requires numpy scipy pandas patsy matplotlib cvxopt
%py3_requires statsmodels.stats.multitest
%add_python3_req_skip models

%description
Statsmodels is a Python package that provides a complement to scipy for
statistical computations including descriptive statistics and estimation
and inference for statistical models.

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: python3-module-%oname = %EVR
%add_python3_req_skip rpy
%add_python3_req_skip yapf.yapflib.yapf_api

%description tests
Statsmodels is a Python package that provides a complement to scipy for
statistical computations including descriptive statistics and estimation
and inference for statistical models.

This package contains tests for %oname.

%prep
%setup
%patch1 -p1
%patch2 -p1
%patch3 -p1

# fix version info
sed -i \
	-e "s/git_refnames\s*=\s*\"[^\"]*\"/git_refnames = \" \(tag: v%version\)\"/" \
	%rname/_version.py

%build
%add_optflags -fno-strict-aliasing
%python3_build_debug -j${NPROCS:-%__nprocs}

%install
%python3_install

%ifnarch armh
%check
# quite a few tests fail on armh. disable it for now
export PIP_NO_INDEX=YES
export PIP_NO_BUILD_ISOLATION=no
export TOXENV=py%{python_version_nodots python3}
tox.py3 --sitepackages -p auto -o -v
%endif

%files
%doc LICENSE.txt
%doc *.md *.rst README_l1.txt
%python3_sitelibdir/%rname
%python3_sitelibdir/%rname-%version-*.egg-info
%exclude %python3_sitelibdir/%rname/*/*/*/example*
%exclude %python3_sitelibdir/%rname/*/*/example*
%exclude %python3_sitelibdir/%rname/*/*/*/test*
%exclude %python3_sitelibdir/%rname/*/*/test*
%exclude %python3_sitelibdir/%rname/*/test*

%files tests
%python3_sitelibdir/%rname/*/*/*/example*
%python3_sitelibdir/%rname/*/*/example*
%python3_sitelibdir/%rname/*/*/*/test*
%python3_sitelibdir/%rname/*/*/test*
%python3_sitelibdir/%rname/*/test*

%changelog
