%define _unpackaged_files_terminate_build 1

%define oname shapely

# Tests fail on i586 due to fp math precision
%ifarch %ix86
%def_disable check
%endif
%def_with doc

Name: python3-module-%oname
Version: 1.7.1
Release: alt2

Summary: Planar geometries, predicates, and operations
License: BSD
Group: Development/Python3

Url: http://pypi.python.org/pypi/Shapely
# https://github.com/Toblerity/Shapely.git
Source: %name-%version.tar

# Backport a relevant subset of commit
# 611a0b3b2047bf8a49db32dc4b30684a10f5b6eb, which fixes
# https://github.com/Toblerity/Shapely/issues/1079 (Test failure with geos
# 3.9.0) and corresponds to https://github.com/Toblerity/Shapely/pull/1042/
# (Expand CI and tests to support GEOS 3.9.0beta2). The particular test vectors
# must be adjusted in the backport because
# https://github.com/Toblerity/Shapely/pull/1031 is not in 1.7.1;
# in particular, “WKTWriter.defaults = {}” is still in tests/__init__.py.
Patch: shapely-1.7.1-611a0b3b-subset.patch

BuildRequires(pre): rpm-build-python3 rpm-macros-sphinx3
BuildRequires: libgeos-devel
BuildRequires: python3-module-Cython libnumpy-py3-devel
BuildRequires: python3-module-descartes
BuildRequires: python3-module-packaging
BuildRequires: python3-module-pytest
BuildRequires: python3-module-numpy-testing
BuildRequires: xvfb-run
%if_with doc
BuildRequires: python3-module-sphinx
BuildRequires: /usr/bin/sphinx-apidoc
BuildRequires: python3(matplotlib.sphinxext)
%endif

%description
Planar geometries, predicates, and operations.

%package examples
Summary: Examples for %oname
Group: Development/Python3
Requires: %name = %EVR

%description examples
Planar geometries, predicates, and operations.

This package contains examples for %oname.

%package pickles
Summary: Pickles for %oname
Group: Development/Python3
%add_python3_req_skip figures

%description pickles
Planar geometries, predicates, and operations.

This package contains pickles for %oname.

%package docs
Summary: Documentation for %oname
Group: Development/Documentation
BuildArch: noarch

%description docs
Planar geometries, predicates, and operations.

This package contains documentation for %oname.

%prep
%setup
%patch -p1

%if_with doc
%prepare_sphinx3 .
ln -s ../objects.inv docs/
%endif

%build
export LC_ALL=en_US.UTF-8
%add_optflags -fno-strict-aliasing

%python3_build

%install
export LC_ALL=en_US.UTF-8

%python3_install

%if_with doc
%make SPHINXBUILD="sphinx-build-3" -C docs pickle
%make SPHINXBUILD="sphinx-build-3" -C docs html

cp -fR docs/_build/pickle %buildroot%python3_sitelibdir/%oname/
%endif

%check
export LC_ALL=en_US.UTF-8

xvfb-run python3 setup.py test
python3 setup.py build_ext -i
py.test3 -vv

%files
%python3_sitelibdir/*
%if_with doc
%exclude %python3_sitelibdir/*/pickle
%endif
%exclude %python3_sitelibdir/*/examples

%files examples
%python3_sitelibdir/*/examples

%if_with doc
%files pickles
%python3_sitelibdir/*/pickle

%files docs
%doc docs/_build/html/*
%endif

%changelog
