%define _unpackaged_files_terminate_build 1

%def_enable docs
%def_enable check

%define oname sphinx
%define sphinx3_dir %python3_sitelibdir_noarch/%oname

Name: python3-module-%oname
Epoch: 1
Version: 4.0.2
Release: alt2

Summary: Tool for producing documentation for Python projects
License: BSD
Group: Development/Python3
Url: http://sphinx-doc.org

BuildArch: noarch

%py3_requires sphinxcontrib.applehelp
%py3_requires sphinxcontrib.devhelp
%py3_requires sphinxcontrib.htmlhelp
%py3_requires sphinxcontrib.jsmath
%py3_requires sphinxcontrib.qthelp
%py3_requires alabaster
%py3_requires requests

Provides: python3-module-objects.inv
Obsoletes: python3-module-objects.inv

# Source0-url: https://github.com/sphinx-doc/sphinx/archive/refs/tags/v%version.tar.gz
Source0: sphinx-%version.tar.gz
Source1: conf.py.template
Source2: macro3
Source3: refcounting.py

Patch1: %oname-alt-tests-offline.patch
Patch2: sphinx-4.0.1-man_1.patch
Patch3: sphinx-4.0.2-Fix-test-Tests-has-been-broken-with-pygments-2.10.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: python-sphinx-objects.inv
BuildRequires: /usr/bin/convert

%if_enabled check
BuildRequires: python3(_testcapi)
BuildRequires: python3(pytest)
BuildRequires: python3-module-html5lib
BuildRequires: python3-module-nose
BuildRequires: python3(typing)
BuildRequires: python3(sphinxcontrib.websupport)
BuildRequires: python3(sphinxcontrib.serializinghtml)
BuildRequires: python3(sphinxcontrib.applehelp)
BuildRequires: python3(sphinxcontrib.devhelp)
BuildRequires: python3(sphinxcontrib.htmlhelp)
BuildRequires: python3(sphinxcontrib.qthelp)
BuildRequires: python3(sphinxcontrib.jsmath)
# For running the new sphinx itself (and generating the docs):
BuildRequires: python3(imagesize)
BuildRequires: python3(mock)
BuildRequires: python3(docutils)
BuildRequires: python3(jinja2)
BuildRequires: python3(pygments)
BuildRequires: python3-module-SQLAlchemy >= 1.0.8-alt2
# These 2 must be recent to pass the tests:
BuildRequires: python3-module-Pygments >= 2.1.3
BuildRequires: python3-module-alabaster >= 0.7.6-alt2.git20150703
# Tox test suite
BuildRequires: python3-module-Cython python3-module-pytest-cov python3-module-tox
%endif

%description
Sphinx is a tool that makes it easy to create intelligent and beautiful
documentation for Python projects (or other documents consisting of
multiple reStructuredText sources)

%package devel
Summary: Development package for Sphinx
Group: Development/Python3
Requires: python3-module-%oname = %EVR
Requires: rpm-macros-sphinx3 = %EVR

%description devel
Sphinx is a tool that makes it easy to create intelligent and beautiful
documentation for Python projects (or other documents consisting of
multiple reStructuredText sources)

This package destinated for development of Python modules.

%package tests
Summary: Tests for Sphinx
Group: Development/Python3
Requires: python3-module-%oname = %EVR
%py3_requires nose
%add_python3_req_skip compiler
%add_python3_req_skip missing_module missing_package1 missing_package2
%add_python3_req_skip missing_package3
%add_python3_req_skip dummy missing_package1.missing_module1 missing_package3.missing_module3
%add_python3_req_skip mod_resource mod_something sphinx.missing_module4 unknown

%description tests
Sphinx is a tool that makes it easy to create intelligent and beautiful
documentation for Python projects (or other documents consisting of
multiple reStructuredText sources)

This packages contains tests for Sphinx.

%if_enabled docs
%package doc
Summary: Documentation for Sphinx
Group: Development/Python3
%add_findreq_skiplist %sphinx3_dir/pickle/_downloads/example_google.py
%add_findreq_skiplist %sphinx3_dir/pickle/_downloads/example_numpy.py

%description doc
Sphinx is a tool that makes it easy to create intelligent and beautiful
documentation for Python projects (or other documents consisting of
multiple reStructuredText sources)

This package contains documentation for Sphinx itself.

%package pickles
Summary: Pickles for Sphinx
Group: Development/Python3

%description pickles
Sphinx is a tool that makes it easy to create intelligent and beautiful
documentation for Python projects (or other documents consisting of
multiple reStructuredText sources)

This packages contains pickles for Sphinx.
%endif

%package -n rpm-macros-sphinx3
Summary: RPM macros for build with Sphinx (Python 3)
Group: Development/Python3

# W.r.t. to the content of the macros (see the substitution in %%install):
#Requires: %sphinx3_dir
# ...but -- see the comment for rpm-macros-sphinx.

%description -n rpm-macros-sphinx3
Sphinx is a tool that makes it easy to create intelligent and beautiful
documentation for Python projects (or other documents consisting of
multiple reStructuredText sources)

This packages contains RPM macros for build with Sphinx.

%prep
%setup -n sphinx-%version
%patch1 -p1
#patch2 -p1
%patch3 -p1

# ship the stable releases
sed -i '/^tag_build =.*/d;/^tag_date =.*/d' setup.cfg

install -pm644 %SOURCE1 .

ln -s %_datadir/python-sphinx/objects.inv doc/
ln -s %_datadir/python-sphinx/objects.inv tests/

cp %SOURCE3 sphinx/ext/
install -pm644 %SOURCE2 .

%build
%python3_build

%if_enabled docs
# docs
%make_build -C doc html
%make_build -C doc man
%endif

%install
%python3_install

cp -R tests %buildroot%sphinx3_dir/
for i in $(find %buildroot%sphinx3_dir/tests -type d)
do
	touch $i/__init__.py
done

ln -rs %buildroot%_datadir/python-sphinx/objects.inv \
	%buildroot%sphinx3_dir/
# There is some objects.inv there already; probably, we want to update it:
ln -frs %buildroot%_datadir/python-sphinx/objects.inv \
	%buildroot%sphinx3_dir/tests/

pushd %buildroot%_bindir
for i in $(ls); do
    mv $i py3_$i
    ln -s py3_$i $i-3
    ln -s py3_$i $i-%__python3_version
done
popd

%if_enabled docs
# docs
install -d %buildroot%_docdir/%name
install -d %buildroot%_man1dir
cp -R doc/_build/html %buildroot%_docdir/%name/
install -p -m644 AUTHORS CHANGES* EXAMPLES LICENSE README.rst \
	%buildroot%_docdir/%name
%endif

# macros
install -d %buildroot%_rpmmacrosdir
sed -e 's:@SPHINX3_DIR@:%sphinx3_dir:g' < macro3 > %buildroot%_rpmmacrosdir/sphinx3

%if_enabled docs
# add pickle files
%make_build -C doc pickle

install -d %buildroot%sphinx3_dir/doctrees
install -p -m644 doc/_build/doctrees/*.pickle \
	%buildroot%sphinx3_dir/doctrees/
cp -R doc/_build/pickle %buildroot%sphinx3_dir/
%endif

install -p -m644 conf.py.template \
	%buildroot%sphinx3_dir/

mkdir -p %buildroot%_rpmlibdir
cat <<\EOF >%buildroot%_rpmlibdir/python3-module-%oname-files.req.list
%sphinx3_dir	python3-module-%oname
EOF

%check
# Tried to export NOSE_PROCESSES=%%__nprocs, but it makes a lot tests fail.
export LC_ALL=en_US.utf8 # some tests fail otherwise, because they use paths with Unicode
export TESTS_NO_NETWORK=1

# disable remote tests
rm -f tests/test_build_linkcheck.py
export TESTS_NO_NETWORK=yes
export PIP_NO_BUILD_ISOLATION=no
export PIP_NO_INDEX=YES
export TOX_TESTENV_PASSENV="PIP_NO_BUILD_ISOLATION TESTS_NO_NETWORK"
export TOXENV=py3
tox.py3 --sitepackages -vvr -s false -- -vra

%files
%_bindir/*
%sphinx3_dir/
%exclude %sphinx3_dir/tests
%exclude %sphinx3_dir/testing
%if_enabled docs
%exclude %sphinx3_dir/pickle
%exclude %sphinx3_dir/doctrees
%endif
%python3_sitelibdir/Sphinx-%version-py%_python3_version.egg-info/

%files devel
%files tests
%sphinx3_dir/tests
%sphinx3_dir/testing

%if_enabled docs
%files pickles
%sphinx3_dir/pickle
%sphinx3_dir/doctrees

%files doc
%doc %_docdir/%name
%endif

%files -n rpm-macros-sphinx3
%_rpmmacrosdir/sphinx3
%_rpmlibdir/python3-module-%oname-files.req.list

%changelog
