%define mname sphinxcontrib
%define oname %mname-images

%def_without docs

Name: python3-module-%oname
Version: 0.7.0
Release: alt2

Summary: Sphinx "images" extension
License: ASLv2.0
Group: Development/Python3
BuildArch: noarch
Url: https://pypi.python.org/pypi/sphinxcontrib-images/
# https://github.com/spinus/sphinxcontrib-images.git

Source: %name-%version.tar
# https://github.com/lokesh/lightbox2.git
Source1: lightbox2.tar

Patch1: %oname-%version-alt-build.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-requests
BuildRequires: python3-module-tox
BuildRequires: python3-module-wheel
%if_with docs
BuildRequires: python3-module-sphinx-devel
%endif

%py3_provides %mname.images
%py3_requires %mname sphinx requests json


%description
sphinxcontrib-images (formerly sphinxcontrib-fancybox).

Features:

* Show thumbnails instead of full size images inside documentation.
* Ability to zoom/enlarge picture using LightBox2 (or any other backend)
* Ability to group pictures
* Download remote pictures (if requested)

%prep
%setup
%patch1 -p1

pushd sphinxcontrib_images_lightbox2
tar -xf %SOURCE1
popd

sed -i 's|#!/usr/bin/env python|#!/usr/bin/env python3|' \
    $(find ./ -name '*.py')

sed -i 's|sphinx-build|sphinx-build-3|' docs/Makefile

%build
export LC_ALL=en_US.UTF-8

%python3_build_debug

%install
export LC_ALL=en_US.UTF-8
%python3_install

%if_with docs
export PYTHONPATH=$PWD
%make -C docs html
%endif

%files
%doc *.rst
%_bindir/*
%python3_sitelibdir/%mname/*
%python3_sitelibdir/sphinxcontrib_images*


%changelog
