%define  modulename starlette

Name:    python3-module-%modulename
Version: 0.28.0
Release: alt1.p10.1

Summary: The little ASGI framework that shines

License: BSD-3-Clause
Group:   Development/Python3
URL:     https://www.starlette.io/

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: https://github.com/encode/starlette/archive/%version.tar.gz
Source:  %modulename-%version.tar

BuildRequires(pre): rpm-build-pyproject
BuildRequires: python3(setuptools)
BuildRequires: python3(wheel)
BuildRequires: python3(hatchling)
BuildRequires: python3(tomli)

# See ALT#43483
%filter_from_requires /python(multipart.*)/d
Requires: python3(python-multipart)

BuildArch: noarch

%description
Starlette is a lightweight ASGI framework/toolkit,
which is ideal for building high performance asyncio services.

It is production-ready, and gives you the following:

Seriously impressive performance.
WebSocket support.
GraphQL support.
In-process background tasks.
Startup and shutdown events.
Test client built on requests.
CORS, GZip, Static Files, Streaming responses.
Session and Cookie support.
100%% test coverage.
100%% type annotated codebase.
Zero hard dependencies.


%prep
%setup -n %modulename-%version

%build
%pyproject_build

%install
%pyproject_install

%files
%python3_sitelibdir/%modulename
%python3_sitelibdir/%modulename-%version.dist-info

%changelog
