%define _unpackaged_files_terminate_build 1

%def_with check

Name: python3-module-systemd
Epoch: 1
Version: 234
Release: alt2
Summary: Python module wrapping systemd functionality
Group: Development/Python3

License: LGPLv2+
Url: https://github.com/systemd/python-systemd
Source: %name-%version.tar
Patch1: %name-snapshot.patch

BuildPreReq: rpm-build-python3
BuildRequires: python3-devel python3-module-lxml
BuildRequires: libsystemd-devel

%if_with check
BuildRequires: python3(pytest)
BuildRequires: python3(tox)
%endif

%description
Python module for native access to the systemd facilities.
Functionality includes sending of structured messages to the journal
and reading journal files, querying machine and boot identifiers and a
lists of message identifiers provided by systemd. Other functionality
provided by libsystemd is also wrapped.

%prep
%setup -q
%patch1 -p1

%build
%python3_build

%install
%python3_install

# don't package tests
rm -r %buildroot%python3_sitelibdir/systemd/test/

%check
cat > tox.ini <<EOF
[testenv]
whitelist_externals =
    /bin/cp
    /bin/sed
commands_pre =
    /bin/cp /usr/bin/py.test3 {envbindir}/py.test
    /bin/sed -i '1c #!{envpython}' {envbindir}/py.test
commands =
    {envbindir}/py.test {posargs} ./systemd/test/
EOF
export PIP_NO_BUILD_ISOLATION=no
export PIP_NO_INDEX=YES
export TOXENV=py3
tox.py3 --sitepackages -vvr

%files
%doc README.md LICENSE.txt
%python3_sitelibdir/*

%changelog
